/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled.details;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.base.Throwables;
import org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.WatchMode;
import org.apache.curator.x.async.api.AsyncCuratorFrameworkDsl;
import org.apache.curator.x.async.api.AsyncPathAndBytesable;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.AsyncSetDataBuilder;
import org.apache.curator.x.async.api.AsyncTransactionSetDataBuilder;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.api.WatchableAsyncCuratorFramework;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ModeledFramework;
import org.apache.curator.x.async.modeled.ModeledOptions;
import org.apache.curator.x.async.modeled.ZNode;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.curator.x.async.modeled.cached.CachedModeledFramework;
import org.apache.curator.x.async.modeled.details.CachedModeledFrameworkImpl;
import org.apache.curator.x.async.modeled.details.ModelStage;
import org.apache.curator.x.async.modeled.details.VersionedModeledFrameworkImpl;
import org.apache.curator.x.async.modeled.details.ZNodeImpl;
import org.apache.curator.x.async.modeled.versioned.VersionedModeledFramework;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ModeledFrameworkImpl<T>
implements ModeledFramework<T> {
    private final AsyncCuratorFramework client;
    private final WatchableAsyncCuratorFramework watchableClient;
    private final ModelSpec<T> modelSpec;
    private final WatchMode watchMode;
    private final UnaryOperator<WatchedEvent> watcherFilter;
    private final UnhandledErrorListener unhandledErrorListener;
    private final UnaryOperator<CuratorEvent> resultFilter;
    private final AsyncCuratorFrameworkDsl dslClient;
    private final boolean isWatched;
    private final Set<ModeledOptions> modeledOptions;

    public static <T> ModeledFrameworkImpl<T> build(AsyncCuratorFramework client, ModelSpec<T> model, WatchMode watchMode, UnaryOperator<WatchedEvent> watcherFilter, UnhandledErrorListener unhandledErrorListener, UnaryOperator<CuratorEvent> resultFilter, Set<ModeledOptions> modeledOptions) {
        boolean isWatched = watchMode != null;
        Objects.requireNonNull(client, "client cannot be null");
        Objects.requireNonNull(model, "model cannot be null");
        modeledOptions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(modeledOptions, "modeledOptions cannot be null"));
        watchMode = watchMode != null ? watchMode : WatchMode.stateChangeAndSuccess;
        AsyncCuratorFrameworkDsl dslClient = client.with(watchMode, unhandledErrorListener, resultFilter, watcherFilter);
        WatchableAsyncCuratorFramework watchableClient = isWatched ? dslClient.watched() : dslClient;
        return new ModeledFrameworkImpl<T>(client, dslClient, watchableClient, model, watchMode, watcherFilter, unhandledErrorListener, resultFilter, isWatched, (Set<ModeledOptions>)modeledOptions);
    }

    private ModeledFrameworkImpl(AsyncCuratorFramework client, AsyncCuratorFrameworkDsl dslClient, WatchableAsyncCuratorFramework watchableClient, ModelSpec<T> modelSpec, WatchMode watchMode, UnaryOperator<WatchedEvent> watcherFilter, UnhandledErrorListener unhandledErrorListener, UnaryOperator<CuratorEvent> resultFilter, boolean isWatched, Set<ModeledOptions> modeledOptions) {
        this.client = client;
        this.dslClient = dslClient;
        this.watchableClient = watchableClient;
        this.modelSpec = modelSpec;
        this.watchMode = watchMode;
        this.watcherFilter = watcherFilter;
        this.unhandledErrorListener = unhandledErrorListener;
        this.resultFilter = resultFilter;
        this.isWatched = isWatched;
        this.modeledOptions = modeledOptions;
    }

    @Override
    public CachedModeledFramework<T> cached() {
        return this.cached(ThreadUtils.newSingleThreadExecutor((String)"CachedModeledFramework"));
    }

    @Override
    public CachedModeledFramework<T> cached(ExecutorService executor) {
        Preconditions.checkState((!this.isWatched ? 1 : 0) != 0, (Object)"CachedModeledFramework cannot be used with watched instances as the internal cache would bypass the watchers.");
        return new CachedModeledFrameworkImpl(this, Objects.requireNonNull(executor, "executor cannot be null"));
    }

    @Override
    public VersionedModeledFramework<T> versioned() {
        return new VersionedModeledFrameworkImpl(this);
    }

    @Override
    public ModelSpec<T> modelSpec() {
        return this.modelSpec;
    }

    @Override
    public AsyncCuratorFramework unwrap() {
        return this.client;
    }

    @Override
    public AsyncStage<String> set(T item) {
        return this.set(item, null, -1);
    }

    @Override
    public AsyncStage<String> set(T item, Stat storingStatIn) {
        return this.set(item, storingStatIn, -1);
    }

    @Override
    public AsyncStage<String> set(T item, int version) {
        return this.set(item, null, version);
    }

    @Override
    public AsyncStage<String> set(T item, Stat storingStatIn, int version) {
        try {
            byte[] bytes = this.modelSpec.serializer().serialize(item);
            return this.dslClient.create().withOptions(this.modelSpec.createOptions(), this.modelSpec.createMode(), this.fixAclList(this.modelSpec.aclList()), storingStatIn, this.modelSpec.ttl(), version).forPath(this.resolveForSet(item), bytes);
        }
        catch (Exception e) {
            return ModelStage.exceptionally(e);
        }
    }

    @Override
    public AsyncStage<T> read() {
        return this.internalRead(ZNode::model, null);
    }

    @Override
    public AsyncStage<T> read(Stat storingStatIn) {
        return this.internalRead(ZNode::model, storingStatIn);
    }

    @Override
    public AsyncStage<ZNode<T>> readAsZNode() {
        return this.internalRead(Function.identity(), null);
    }

    @Override
    public AsyncStage<Stat> update(T item) {
        return this.update(item, -1);
    }

    @Override
    public AsyncStage<Stat> update(T item, int version) {
        try {
            byte[] bytes = this.modelSpec.serializer().serialize(item);
            AsyncSetDataBuilder dataBuilder = this.dslClient.setData();
            AsyncPathAndBytesable<AsyncStage<Stat>> next = this.isCompressed() ? dataBuilder.compressedWithVersion(version) : dataBuilder.uncompressedWithVersion(version);
            return next.forPath(this.resolveForSet(item), bytes);
        }
        catch (Exception e) {
            return ModelStage.exceptionally(e);
        }
    }

    @Override
    public AsyncStage<Stat> checkExists() {
        return (AsyncStage)this.watchableClient.checkExists().forPath(this.modelSpec.path().fullPath());
    }

    @Override
    public AsyncStage<Void> delete() {
        return this.delete(-1);
    }

    @Override
    public AsyncStage<Void> delete(int version) {
        return this.dslClient.delete().withOptionsAndVersion(this.modelSpec.deleteOptions(), version).forPath(this.modelSpec.path().fullPath());
    }

    @Override
    public AsyncStage<List<ZPath>> children() {
        return this.internalGetChildren(this.modelSpec.path());
    }

    @Override
    public AsyncStage<List<ZNode<T>>> childrenAsZNodes() {
        ModelStage<List<ZNode<T>>> modelStage = ModelStage.make();
        Preconditions.checkState((!this.isWatched ? 1 : 0) != 0, (Object)"childrenAsZNodes() cannot be used with watched instances.");
        this.children().handle((children, e) -> {
            if (e != null) {
                modelStage.completeExceptionally((Throwable)e);
            } else {
                this.completeChildrenAsZNodes(modelStage, (List<ZPath>)children);
            }
            return null;
        });
        return modelStage;
    }

    private void completeChildrenAsZNodes(ModelStage<List<ZNode<T>>> modelStage, List<ZPath> children) {
        ArrayList nodes = Lists.newArrayList();
        if (children.size() == 0) {
            modelStage.complete(nodes);
            return;
        }
        children.forEach(path -> this.withPath((ZPath)path).readAsZNode().handle((node, e) -> {
            if (e != null) {
                modelStage.completeExceptionally((Throwable)e);
            } else {
                nodes.add(node);
                if (nodes.size() == children.size()) {
                    modelStage.complete(nodes);
                }
            }
            return null;
        }));
    }

    private AsyncStage<List<ZPath>> internalGetChildren(ZPath path) {
        AsyncStage asyncStage = (AsyncStage)this.watchableClient.getChildren().forPath(path.fullPath());
        ModelStage<List<ZPath>> modelStage = ModelStage.make(asyncStage.event());
        asyncStage.whenComplete((children, e) -> {
            if (e != null) {
                if (this.modeledOptions.contains((Object)ModeledOptions.ignoreMissingNodesForChildren) && Throwables.getRootCause((Throwable)e) instanceof KeeperException.NoNodeException) {
                    modelStage.complete(Collections.emptyList());
                } else {
                    modelStage.completeExceptionally((Throwable)e);
                }
            } else {
                modelStage.complete(children.stream().map(path::child).collect(Collectors.toList()));
            }
        });
        return modelStage;
    }

    @Override
    public ModeledFramework<T> parent() {
        ModelSpec<T> newModelSpec = this.modelSpec.parent();
        return new ModeledFrameworkImpl<T>(this.client, this.dslClient, this.watchableClient, newModelSpec, this.watchMode, this.watcherFilter, this.unhandledErrorListener, this.resultFilter, this.isWatched, this.modeledOptions);
    }

    @Override
    public ModeledFramework<T> child(Object child) {
        ModelSpec<T> newModelSpec = this.modelSpec.child(child);
        return new ModeledFrameworkImpl<T>(this.client, this.dslClient, this.watchableClient, newModelSpec, this.watchMode, this.watcherFilter, this.unhandledErrorListener, this.resultFilter, this.isWatched, this.modeledOptions);
    }

    @Override
    public ModeledFramework<T> withPath(ZPath path) {
        ModelSpec<T> newModelSpec = this.modelSpec.withPath(path);
        return new ModeledFrameworkImpl<T>(this.client, this.dslClient, this.watchableClient, newModelSpec, this.watchMode, this.watcherFilter, this.unhandledErrorListener, this.resultFilter, this.isWatched, this.modeledOptions);
    }

    public static boolean isCompressed(Set<CreateOption> createOptions) {
        return createOptions.contains((Object)CreateOption.compress);
    }

    @Override
    public CuratorOp createOp(T model) {
        return this.client.transactionOp().create().withOptions(this.modelSpec.createMode(), this.fixAclList(this.modelSpec.aclList()), this.isCompressed(), this.modelSpec.ttl()).forPath(this.resolveForSet(model), this.modelSpec.serializer().serialize(model));
    }

    @Override
    public CuratorOp updateOp(T model) {
        return this.updateOp(model, -1);
    }

    @Override
    public CuratorOp updateOp(T model, int version) {
        AsyncTransactionSetDataBuilder builder = this.client.transactionOp().setData();
        AsyncPathAndBytesable<CuratorOp> builder2 = this.isCompressed() ? builder.withVersionCompressed(version) : builder.withVersionUncompressed(version);
        return builder2.forPath(this.resolveForSet(model), this.modelSpec.serializer().serialize(model));
    }

    @Override
    public CuratorOp deleteOp() {
        return this.deleteOp(-1);
    }

    @Override
    public CuratorOp deleteOp(int version) {
        return this.client.transactionOp().delete().withVersion(version).forPath(this.modelSpec.path().fullPath());
    }

    @Override
    public CuratorOp checkExistsOp() {
        return this.checkExistsOp(-1);
    }

    @Override
    public CuratorOp checkExistsOp(int version) {
        return this.client.transactionOp().check().withVersion(version).forPath(this.modelSpec.path().fullPath());
    }

    @Override
    public AsyncStage<List<CuratorTransactionResult>> inTransaction(List<CuratorOp> operations) {
        return this.client.transaction().forOperations(operations);
    }

    private boolean isCompressed() {
        if (this.modelSpec.createOptions().contains((Object)CreateOption.compress)) {
            return true;
        }
        if (this.modelSpec.createOptions().contains((Object)CreateOption.uncompress)) {
            return false;
        }
        return this.client.unwrap().compressionEnabled();
    }

    private <U> ModelStage<U> internalRead(Function<ZNode<T>, U> resolver, Stat storingStatIn) {
        Stat stat = storingStatIn != null ? storingStatIn : new Stat();
        AsyncPathable<AsyncStage<byte[]>> next = this.isCompressed() ? this.watchableClient.getData().decompressedStoringStatIn(stat) : this.watchableClient.getData().undecompressedStoringStatIn(stat);
        AsyncStage<byte[]> asyncStage = next.forPath(this.modelSpec.path().fullPath());
        ModelStage modelStage = ModelStage.make(asyncStage.event());
        asyncStage.whenComplete((value, e) -> {
            if (e != null) {
                modelStage.completeExceptionally((Throwable)e);
            } else {
                try {
                    ZNodeImpl<T> node = new ZNodeImpl<T>(this.modelSpec.path(), stat, this.modelSpec.serializer().deserialize((byte[])value));
                    modelStage.complete(resolver.apply(node));
                }
                catch (Exception deserializeException) {
                    modelStage.completeExceptionally(deserializeException);
                }
            }
        });
        return modelStage;
    }

    private String resolveForSet(T model) {
        if (this.modelSpec.path().isResolved()) {
            return this.modelSpec.path().fullPath();
        }
        return this.modelSpec.path().resolved(model).fullPath();
    }

    private List<ACL> fixAclList(List<ACL> aclList) {
        return aclList.size() > 0 ? aclList : null;
    }
}

