/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.WatchableBase;
import org.apache.curator.framework.imps.AddWatchBuilderImpl;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.Watching;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.AsyncWatchBuilder;
import org.apache.curator.x.async.api.AsyncWatchBuilder2;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.Watcher;

class AsyncWatchBuilderImpl
implements AsyncWatchBuilder,
AsyncWatchBuilder2,
WatchableBase<AsyncPathable<AsyncStage<Void>>>,
AsyncPathable<AsyncStage<Void>> {
    private final CuratorFrameworkBase client;
    private final Filters filters;
    private Watching watching;
    private AddWatchMode mode = AddWatchMode.PERSISTENT_RECURSIVE;

    AsyncWatchBuilderImpl(CuratorFrameworkBase client, Filters filters) {
        this.client = client;
        this.filters = filters;
        this.watching = new Watching(client, true);
    }

    @Override
    public AsyncWatchBuilder2 withMode(AddWatchMode mode) {
        this.mode = mode;
        return this;
    }

    public AsyncPathable<AsyncStage<Void>> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    public AsyncPathable<AsyncStage<Void>> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public AsyncStage<Void> forPath(String path) {
        BuilderCommon<Void> common = new BuilderCommon<Void>(this.filters, BackgroundProcs.ignoredProc);
        AddWatchBuilderImpl builder = new AddWatchBuilderImpl(this.client, this.watching, common.backgrounding, this.mode);
        return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
    }
}

