/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.DeleteBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.AsyncDeleteBuilder;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.DeleteOption;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;

class AsyncDeleteBuilderImpl
implements AsyncDeleteBuilder {
    private final CuratorFrameworkBase client;
    private final Filters filters;
    private Set<DeleteOption> options = Collections.emptySet();
    private int version = -1;

    AsyncDeleteBuilderImpl(CuratorFrameworkBase client, Filters filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> withOptions(Set<DeleteOption> options) {
        return this.withOptionsAndVersion(options, -1);
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> withOptionsAndVersion(Set<DeleteOption> options, int version) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.version = version;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public AsyncStage<Void> forPath(String path) {
        BuilderCommon<Void> common = new BuilderCommon<Void>(this.filters, BackgroundProcs.ignoredProc);
        DeleteBuilderImpl builder = new DeleteBuilderImpl(this.client, this.version, common.backgrounding, this.options.contains((Object)DeleteOption.deletingChildrenIfNeeded), this.options.contains((Object)DeleteOption.guaranteed), this.options.contains((Object)DeleteOption.quietly));
        return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
    }
}

