/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.curator.framework.imps.CreateBuilderImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.AsyncCreateBuilder;
import org.apache.curator.x.async.api.AsyncPathAndBytesable;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class AsyncCreateBuilderImpl
implements AsyncCreateBuilder {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private CreateMode createMode = CreateMode.PERSISTENT;
    private List<ACL> aclList = null;
    private Set<CreateOption> options = Collections.emptySet();
    private Stat stat = null;
    private long ttl = -1L;
    private int setDataVersion = -1;

    AsyncCreateBuilderImpl(CuratorFrameworkImpl client, Filters filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> storingStatIn(Stat stat) {
        this.stat = stat;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withMode(CreateMode createMode) {
        this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withACL(List<ACL> aclList) {
        this.aclList = aclList;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withSetDataVersion(int version) {
        this.setDataVersion = version;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withOptions(Set<CreateOption> options) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withOptions(Set<CreateOption> options, List<ACL> aclList) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.aclList = aclList;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withOptions(Set<CreateOption> options, CreateMode createMode, List<ACL> aclList) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.aclList = aclList;
        this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withOptions(Set<CreateOption> options, CreateMode createMode) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withOptions(Set<CreateOption> options, CreateMode createMode, List<ACL> aclList, Stat stat) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.aclList = aclList;
        this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
        this.stat = stat;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withOptions(Set<CreateOption> options, CreateMode createMode, List<ACL> aclList, Stat stat, long ttl) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.aclList = aclList;
        this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
        this.stat = stat;
        this.ttl = ttl;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<String>> withOptions(Set<CreateOption> options, CreateMode createMode, List<ACL> aclList, Stat stat, long ttl, int setDataVersion) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.aclList = aclList;
        this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
        this.stat = stat;
        this.ttl = ttl;
        this.setDataVersion = setDataVersion;
        return this;
    }

    @Override
    public AsyncStage<String> forPath(String path) {
        return this.internalForPath(path, null, false);
    }

    @Override
    public AsyncStage<String> forPath(String path, byte[] data) {
        return this.internalForPath(path, data, true);
    }

    private AsyncStage<String> internalForPath(String path, byte[] data, boolean useData) {
        BuilderCommon<String> common = new BuilderCommon<String>(this.filters, BackgroundProcs.nameProc);
        CreateBuilderImpl builder = new CreateBuilderImpl(this.client, this.createMode, common.backgrounding, this.options.contains((Object)CreateOption.createParentsIfNeeded) || this.options.contains((Object)CreateOption.createParentsAsContainers), this.options.contains((Object)CreateOption.createParentsAsContainers), this.options.contains((Object)CreateOption.doProtected), this.options.contains((Object)CreateOption.compress), this.options.contains((Object)CreateOption.setDataIfExists), this.aclList, this.stat, this.ttl);
        builder.setSetDataIfExistsVersion(this.setDataVersion);
        return BackgroundProcs.safeCall(common.internalCallback, () -> useData ? builder.forPath(path, data) : builder.forPath(path));
    }
}

