/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.api.DeleteOption;
import org.apache.curator.x.async.modeled.ModelSerializer;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.curator.x.async.modeled.details.ModelSpecImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;

public class ModelSpecBuilder<T> {
    private final ModelSerializer<T> serializer;
    private ZPath path;
    private CreateMode createMode = CreateMode.PERSISTENT;
    private List<ACL> aclList = Collections.emptyList();
    private Set<CreateOption> createOptions = Collections.emptySet();
    private Set<DeleteOption> deleteOptions = Collections.emptySet();
    private long ttl = -1L;

    public ModelSpec<T> build() {
        return new ModelSpecImpl<T>(this.path, this.serializer, this.createMode, this.aclList, this.createOptions, this.deleteOptions, this.ttl);
    }

    public ModelSpecBuilder<T> withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public ModelSpecBuilder<T> withTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public ModelSpecBuilder<T> withAclList(List<ACL> aclList) {
        this.aclList = aclList;
        return this;
    }

    public ModelSpecBuilder<T> withCreateOptions(Set<CreateOption> createOptions) {
        this.createOptions = createOptions != null ? ImmutableSet.copyOf(createOptions) : null;
        return this;
    }

    public ModelSpecBuilder<T> withDeleteOptions(Set<DeleteOption> deleteOptions) {
        this.deleteOptions = deleteOptions != null ? ImmutableSet.copyOf(deleteOptions) : null;
        return this;
    }

    public ModelSpecBuilder<T> withPath(ZPath path) {
        this.path = Objects.requireNonNull(path, "path cannot be null");
        return this;
    }

    ModelSpecBuilder(ModelSerializer<T> serializer) {
        this.serializer = Objects.requireNonNull(serializer, "serializer cannot be null");
    }

    ModelSpecBuilder(ZPath path, ModelSerializer<T> serializer) {
        this.path = Objects.requireNonNull(path, "path cannot be null");
        this.serializer = Objects.requireNonNull(serializer, "serializer cannot be null");
    }
}

