/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.x.async.details.BackgroundProc;
import org.apache.curator.x.async.details.InternalCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class BackgroundProcs {
    static final BackgroundProc<String> nameProc = BackgroundProcs.makeProc(CuratorEvent::getName);
    static final BackgroundProc<String> pathProc = BackgroundProcs.makeProc(CuratorEvent::getPath);
    static final BackgroundProc<Void> ignoredProc = BackgroundProcs.makeProc(e -> null);
    static final BackgroundProc<byte[]> dataProc = BackgroundProcs.makeProc(CuratorEvent::getData);
    static final BackgroundProc<Stat> statProc = BackgroundProcs.makeProc(CuratorEvent::getStat);
    static final BackgroundProc<Stat> safeStatProc = (event, future) -> {
        if (event.getResultCode() == 0 || event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
            future.complete(event.getStat());
        } else {
            future.completeExceptionally((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)event.getResultCode()), (String)event.getPath()));
        }
        return null;
    };
    static final BackgroundProc<List<String>> childrenProc = BackgroundProcs.makeProc(CuratorEvent::getChildren);
    static final BackgroundProc<List<ACL>> aclProc = BackgroundProcs.makeProc(CuratorEvent::getACLList);
    static final BackgroundProc<List<CuratorTransactionResult>> opResultsProc = BackgroundProcs.makeProc(CuratorEvent::getOpResults);

    static <T> BackgroundProc<T> makeProc(Function<CuratorEvent, T> proc) {
        return (event, future) -> {
            if (event.getResultCode() == 0) {
                future.complete(proc.apply((CuratorEvent)event));
            } else {
                future.completeExceptionally((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)event.getResultCode()), (String)event.getPath()));
            }
            return null;
        };
    }

    static <T> InternalCallback<T> safeCall(InternalCallback<T> callback, Callable<?> proc) {
        try {
            proc.call();
        }
        catch (Exception e) {
            callback.toCompletableFuture().completeExceptionally(e);
        }
        return callback;
    }

    BackgroundProcs() {
    }
}

