/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled.details;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.curator.framework.schema.Schema;
import org.apache.curator.framework.schema.SchemaValidator;
import org.apache.curator.framework.schema.SchemaViolation;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.api.DeleteOption;
import org.apache.curator.x.async.modeled.ModelSerializer;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class ModelSpecImpl<T>
implements ModelSpec<T>,
SchemaValidator {
    private final ZPath path;
    private final ModelSerializer<T> serializer;
    private final CreateMode createMode;
    private final List<ACL> aclList;
    private final Set<CreateOption> createOptions;
    private final Set<DeleteOption> deleteOptions;
    private final long ttl;
    private volatile Schema schema = null;

    public ModelSpecImpl(ZPath path, ModelSerializer<T> serializer, CreateMode createMode, List<ACL> aclList, Set<CreateOption> createOptions, Set<DeleteOption> deleteOptions, long ttl) {
        this.path = Objects.requireNonNull(path, "path cannot be null");
        this.serializer = Objects.requireNonNull(serializer, "serializer cannot be null");
        this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
        this.aclList = ImmutableList.copyOf((Collection)Objects.requireNonNull(aclList, "aclList cannot be null"));
        this.createOptions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(createOptions, "createOptions cannot be null"));
        this.deleteOptions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(deleteOptions, "deleteOptions cannot be null"));
        this.ttl = ttl;
    }

    @Override
    public ModelSpec<T> child(Object child) {
        return this.withPath(this.path.child(child));
    }

    @Override
    public ModelSpec<T> parent() {
        return this.withPath(this.path.parent());
    }

    @Override
    public ModelSpec<T> resolved(Object ... parameters) {
        return this.withPath(this.path.resolved(parameters));
    }

    @Override
    public ModelSpec<T> resolved(List<Object> parameters) {
        return this.withPath((ZPath)this.path.resolved((List)parameters));
    }

    @Override
    public ModelSpec<T> withPath(ZPath newPath) {
        return new ModelSpecImpl<T>(newPath, this.serializer, this.createMode, this.aclList, this.createOptions, this.deleteOptions, this.ttl);
    }

    @Override
    public ZPath path() {
        return this.path;
    }

    @Override
    public ModelSerializer<T> serializer() {
        return this.serializer;
    }

    @Override
    public CreateMode createMode() {
        return this.createMode;
    }

    @Override
    public List<ACL> aclList() {
        return this.aclList;
    }

    @Override
    public Set<CreateOption> createOptions() {
        return this.createOptions;
    }

    @Override
    public Set<DeleteOption> deleteOptions() {
        return this.deleteOptions;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public Schema schema() {
        if (this.schema == null) {
            this.schema = Schema.builder((Pattern)this.path.toSchemaPathPattern()).dataValidator((SchemaValidator)this).ephemeral(this.createMode.isEphemeral() ? Schema.Allowance.MUST : Schema.Allowance.CANNOT).canBeDeleted(true).sequential(this.createMode.isSequential() ? Schema.Allowance.MUST : Schema.Allowance.CANNOT).watched(Schema.Allowance.CAN).build();
        }
        return this.schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelSpecImpl modelSpec = (ModelSpecImpl)o;
        if (this.ttl != modelSpec.ttl) {
            return false;
        }
        if (!this.path.equals(modelSpec.path)) {
            return false;
        }
        if (!this.serializer.equals(modelSpec.serializer)) {
            return false;
        }
        if (this.createMode != modelSpec.createMode) {
            return false;
        }
        if (!this.aclList.equals(modelSpec.aclList)) {
            return false;
        }
        if (!this.createOptions.equals(modelSpec.createOptions)) {
            return false;
        }
        if (!this.deleteOptions.equals(modelSpec.deleteOptions)) {
            return false;
        }
        return this.schema.equals((Object)modelSpec.schema);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.serializer.hashCode();
        result = 31 * result + this.createMode.hashCode();
        result = 31 * result + this.aclList.hashCode();
        result = 31 * result + this.createOptions.hashCode();
        result = 31 * result + this.deleteOptions.hashCode();
        result = 31 * result + (int)(this.ttl ^ this.ttl >>> 32);
        result = 31 * result + this.schema.hashCode();
        return result;
    }

    public String toString() {
        return "ModelSpecImpl{path=" + this.path + ", serializer=" + this.serializer + ", createMode=" + this.createMode + ", aclList=" + this.aclList + ", createOptions=" + this.createOptions + ", deleteOptions=" + this.deleteOptions + ", ttl=" + this.ttl + ", schema=" + this.schema + '}';
    }

    public boolean isValid(Schema schema, String path, byte[] data, List<ACL> acl) {
        if (acl != null) {
            List<Object> localAclList;
            List<Object> list = localAclList = this.aclList.size() > 0 ? this.aclList : ZooDefs.Ids.OPEN_ACL_UNSAFE;
            if (!acl.equals(localAclList)) {
                throw new SchemaViolation(schema, new SchemaViolation.ViolatorData(path, data, acl), "ACLs do not match model ACLs");
            }
        }
        if (data != null) {
            try {
                this.serializer.deserialize(data);
            }
            catch (RuntimeException e) {
                throw new SchemaViolation(schema, new SchemaViolation.ViolatorData(path, data, acl), "Data cannot be deserialized into a model");
            }
        }
        return true;
    }
}

