/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled;

import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.apache.curator.x.async.modeled.Resolvable;
import org.apache.curator.x.async.modeled.details.ZPathImpl;

public interface ZPath
extends Resolvable {
    public static final ZPath root = ZPathImpl.root;

    public static String parameter() {
        return ZPath.parameter("id");
    }

    public static String parameter(String name) {
        return "/{" + name + "}";
    }

    public static ZPath parse(String fullPath) {
        return ZPathImpl.parse(fullPath, s -> s);
    }

    public static ZPath parseWithIds(String fullPath) {
        return ZPathImpl.parse(fullPath, s -> ZPath.isId(s) ? "/" + s : s);
    }

    public static boolean isId(String s) {
        return s.startsWith("{") && s.endsWith("}");
    }

    public static ZPath parse(String fullPath, UnaryOperator<String> nameFilter) {
        return ZPathImpl.parse(fullPath, nameFilter);
    }

    public static ZPath from(String ... names) {
        return ZPathImpl.from(names);
    }

    public static ZPath from(List<String> names) {
        return ZPathImpl.from(names);
    }

    public static ZPath from(ZPath base, String ... names) {
        return ZPathImpl.from(base, names);
    }

    public static ZPath from(ZPath base, List<String> names) {
        return ZPathImpl.from(base, names);
    }

    @Override
    default public ZPath resolved(Object ... parameters) {
        return this.resolved((List)Arrays.asList(parameters));
    }

    @Override
    public ZPath resolved(List<Object> var1);

    public ZPath child(Object var1);

    public ZPath parent();

    public boolean isRoot();

    public boolean isResolved();

    public boolean startsWith(ZPath var1);

    public String fullPath();

    public String nodeName();

    public Pattern toSchemaPathPattern();
}

