/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.migrations;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.imps.ExtractingCuratorOp;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Throwables;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncWrappers;
import org.apache.curator.x.async.migrations.Migration;
import org.apache.curator.x.async.migrations.MigrationException;
import org.apache.curator.x.async.migrations.MigrationSet;
import org.apache.zookeeper.CreateMode;

public class MigrationManager {
    private final AsyncCuratorFramework client;
    private final String lockPath;
    private final String metaDataPath;
    private final Executor executor;
    private final Duration lockMax;
    private static final String META_DATA_NODE_NAME = "meta-";
    @VisibleForTesting
    volatile AtomicInteger debugCount = null;

    public MigrationManager(AsyncCuratorFramework client, String lockPath, String metaDataPath, Executor executor, Duration lockMax) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.lockPath = Objects.requireNonNull(lockPath, "lockPath cannot be null");
        this.metaDataPath = Objects.requireNonNull(metaDataPath, "metaDataPath cannot be null");
        this.executor = Objects.requireNonNull(executor, "executor cannot be null");
        this.lockMax = Objects.requireNonNull(lockMax, "lockMax cannot be null");
    }

    public CompletionStage<Void> migrate(MigrationSet set) {
        InterProcessSemaphoreMutex lock = new InterProcessSemaphoreMutex(this.client.unwrap(), ZKPaths.makePath((String)this.lockPath, (String)set.id()));
        CompletionStage<Void> lockStage = AsyncWrappers.lockAsync((InterProcessLock)lock, this.lockMax.toMillis(), TimeUnit.MILLISECONDS, this.executor);
        return lockStage.thenCompose(arg_0 -> this.lambda$migrate$0((InterProcessLock)lock, set, arg_0));
    }

    protected List<Migration> filter(MigrationSet set, List<byte[]> operationHashesInOrder) throws MigrationException {
        if (operationHashesInOrder.size() > set.migrations().size()) {
            throw new MigrationException(set.id(), String.format("More metadata than migrations. Migration ID: %s", set.id()));
        }
        int compareSize = Math.min(set.migrations().size(), operationHashesInOrder.size());
        for (int i = 0; i < compareSize; ++i) {
            byte[] setHash = this.hash(set.migrations().get(i).operations());
            if (Arrays.equals(setHash, operationHashesInOrder.get(i))) continue;
            throw new MigrationException(set.id(), String.format("Metadata mismatch. Migration ID: %s", set.id()));
        }
        return set.migrations().subList(operationHashesInOrder.size(), set.migrations().size());
    }

    private byte[] hash(List<CuratorOp> operations) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        operations.forEach(op -> {
            if (op instanceof ExtractingCuratorOp) {
                ((ExtractingCuratorOp)op).addToDigest(digest);
            } else {
                digest.update(op.toString().getBytes());
            }
        });
        return digest.digest();
    }

    private CompletionStage<Void> runMigrationInLock(InterProcessLock lock, MigrationSet set) {
        String thisMetaDataPath = ZKPaths.makePath((String)this.metaDataPath, (String)set.id());
        return AsyncWrappers.childrenWithData(this.client, thisMetaDataPath).thenCompose(metaData -> this.applyMetaData(set, (Map<String, byte[]>)metaData, thisMetaDataPath)).handle((v, e) -> {
            AsyncWrappers.release(lock, true);
            if (e != null) {
                Throwables.propagate((Throwable)e);
            }
            return v;
        });
    }

    private CompletionStage<Void> applyMetaData(MigrationSet set, Map<String, byte[]> metaData, String thisMetaDataPath) {
        List<Migration> toBeApplied;
        List<byte[]> sortedMetaData = metaData.keySet().stream().sorted(Comparator.naturalOrder()).map(metaData::get).collect(Collectors.toList());
        try {
            toBeApplied = this.filter(set, sortedMetaData);
        }
        catch (MigrationException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
        if (toBeApplied.size() == 0) {
            return CompletableFuture.completedFuture(null);
        }
        return AsyncWrappers.asyncEnsureContainers(this.client, thisMetaDataPath).thenCompose(__ -> this.applyMetaDataAfterEnsure(toBeApplied, thisMetaDataPath));
    }

    private CompletionStage<Void> applyMetaDataAfterEnsure(List<Migration> toBeApplied, String thisMetaDataPath) {
        if (this.debugCount != null) {
            this.debugCount.incrementAndGet();
        }
        ArrayList<CuratorOp> operations = new ArrayList<CuratorOp>();
        String metaDataBasePath = ZKPaths.makePath((String)thisMetaDataPath, (String)META_DATA_NODE_NAME);
        toBeApplied.forEach(migration -> {
            List<CuratorOp> thisMigrationOperations = migration.operations();
            operations.addAll(thisMigrationOperations);
            operations.add(this.client.transactionOp().create().withMode(CreateMode.PERSISTENT_SEQUENTIAL).forPath(metaDataBasePath, this.hash(thisMigrationOperations)));
        });
        return this.client.transaction().forOperations(operations).thenApply(__ -> null);
    }

    private /* synthetic */ CompletionStage lambda$migrate$0(InterProcessLock lock, MigrationSet set, Void __) {
        return this.runMigrationInLock(lock, set);
    }
}

