/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.List;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.SetACLBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.AsyncSetACLBuilder;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class AsyncSetACLBuilderImpl
implements AsyncSetACLBuilder,
AsyncPathable<AsyncStage<Stat>> {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private int version = -1;
    private List<ACL> aclList = null;

    AsyncSetACLBuilderImpl(CuratorFrameworkImpl client, Filters filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public AsyncPathable<AsyncStage<Stat>> withACL(List<ACL> aclList) {
        this.aclList = aclList;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Stat>> withACL(List<ACL> aclList, int version) {
        this.aclList = aclList;
        this.version = version;
        return this;
    }

    @Override
    public AsyncStage<Stat> forPath(String path) {
        BuilderCommon<Stat> common = new BuilderCommon<Stat>(this.filters, BackgroundProcs.statProc);
        SetACLBuilderImpl builder = new SetACLBuilderImpl(this.client, common.backgrounding, this.aclList, this.version);
        return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
    }
}

