/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled.cached;

import org.apache.curator.x.async.modeled.ZPath;
import org.apache.zookeeper.data.Stat;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface ModeledCacheListener<T> {
    public void accept(Type var1, ZPath var2, Stat var3, T var4);

    default public void initialized() {
    }

    default public void handleException(Exception e) {
        LoggerFactory.getLogger(this.getClass()).error("Could not process cache message", (Throwable)e);
    }

    default public ModeledCacheListener<T> postInitializedOnly() {
        return new ModeledCacheListener<T>(){
            private volatile boolean isInitialized = false;

            @Override
            public void accept(Type type, ZPath path, Stat stat, T model) {
                if (this.isInitialized) {
                    ModeledCacheListener.this.accept(type, path, stat, model);
                }
            }

            @Override
            public void initialized() {
                this.isInitialized = true;
                ModeledCacheListener.this.initialized();
            }
        };
    }

    public static enum Type {
        NODE_ADDED,
        NODE_UPDATED,
        NODE_REMOVED;

    }
}

