/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.CuratorMultiTransactionImpl;
import org.apache.curator.framework.imps.GetACLBuilderImpl;
import org.apache.curator.framework.imps.SyncBuilderImpl;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.WatchMode;
import org.apache.curator.x.async.api.AsyncCreateBuilder;
import org.apache.curator.x.async.api.AsyncCuratorFrameworkDsl;
import org.apache.curator.x.async.api.AsyncDeleteBuilder;
import org.apache.curator.x.async.api.AsyncExistsBuilder;
import org.apache.curator.x.async.api.AsyncGetACLBuilder;
import org.apache.curator.x.async.api.AsyncGetChildrenBuilder;
import org.apache.curator.x.async.api.AsyncGetConfigBuilder;
import org.apache.curator.x.async.api.AsyncGetDataBuilder;
import org.apache.curator.x.async.api.AsyncMultiTransaction;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.AsyncReconfigBuilder;
import org.apache.curator.x.async.api.AsyncRemoveWatchesBuilder;
import org.apache.curator.x.async.api.AsyncSetACLBuilder;
import org.apache.curator.x.async.api.AsyncSetDataBuilder;
import org.apache.curator.x.async.api.AsyncSyncBuilder;
import org.apache.curator.x.async.api.AsyncTransactionOp;
import org.apache.curator.x.async.api.WatchableAsyncCuratorFramework;
import org.apache.curator.x.async.details.AsyncCreateBuilderImpl;
import org.apache.curator.x.async.details.AsyncDeleteBuilderImpl;
import org.apache.curator.x.async.details.AsyncExistsBuilderImpl;
import org.apache.curator.x.async.details.AsyncGetChildrenBuilderImpl;
import org.apache.curator.x.async.details.AsyncGetConfigBuilderImpl;
import org.apache.curator.x.async.details.AsyncGetDataBuilderImpl;
import org.apache.curator.x.async.details.AsyncReconfigBuilderImpl;
import org.apache.curator.x.async.details.AsyncRemoveWatchesBuilderImpl;
import org.apache.curator.x.async.details.AsyncSetACLBuilderImpl;
import org.apache.curator.x.async.details.AsyncSetDataBuilderImpl;
import org.apache.curator.x.async.details.AsyncTransactionOpImpl;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class AsyncCuratorFrameworkImpl
implements AsyncCuratorFramework {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private final WatchMode watchMode;
    private final boolean watched;

    public AsyncCuratorFrameworkImpl(CuratorFramework client) {
        this(AsyncCuratorFrameworkImpl.reveal(client), new Filters(null, null, null), WatchMode.stateChangeAndSuccess, false);
    }

    private static CuratorFrameworkImpl reveal(CuratorFramework client) {
        try {
            return (CuratorFrameworkImpl)Objects.requireNonNull(client, "client cannot be null");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Only Curator clients created through CuratorFrameworkFactory are supported: " + client.getClass().getName());
        }
    }

    public AsyncCuratorFrameworkImpl(CuratorFrameworkImpl client, Filters filters, WatchMode watchMode, boolean watched) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.filters = Objects.requireNonNull(filters, "filters cannot be null");
        this.watchMode = Objects.requireNonNull(watchMode, "watchMode cannot be null");
        this.watched = watched;
    }

    @Override
    public AsyncCreateBuilder create() {
        return new AsyncCreateBuilderImpl(this.client, this.filters);
    }

    @Override
    public AsyncDeleteBuilder delete() {
        return new AsyncDeleteBuilderImpl(this.client, this.filters);
    }

    @Override
    public AsyncSetDataBuilder setData() {
        return new AsyncSetDataBuilderImpl(this.client, this.filters);
    }

    @Override
    public AsyncGetACLBuilder getACL() {
        return new AsyncGetACLBuilder(){
            private Stat stat = null;

            @Override
            public AsyncPathable<AsyncStage<List<ACL>>> storingStatIn(Stat stat) {
                this.stat = stat;
                return this;
            }

            @Override
            public AsyncStage<List<ACL>> forPath(String path) {
                BuilderCommon<List<ACL>> common = new BuilderCommon<List<ACL>>(AsyncCuratorFrameworkImpl.this.filters, BackgroundProcs.aclProc);
                GetACLBuilderImpl builder = new GetACLBuilderImpl(AsyncCuratorFrameworkImpl.this.client, common.backgrounding, this.stat);
                return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
            }
        };
    }

    @Override
    public AsyncSetACLBuilder setACL() {
        return new AsyncSetACLBuilderImpl(this.client, this.filters);
    }

    @Override
    public AsyncReconfigBuilder reconfig() {
        return new AsyncReconfigBuilderImpl(this.client, this.filters);
    }

    @Override
    public AsyncMultiTransaction transaction() {
        return operations -> {
            BuilderCommon<List<CuratorTransactionResult>> common = new BuilderCommon<List<CuratorTransactionResult>>(this.filters, BackgroundProcs.opResultsProc);
            CuratorMultiTransactionImpl builder = new CuratorMultiTransactionImpl(this.client, common.backgrounding);
            return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forOperations(operations));
        };
    }

    @Override
    public AsyncSyncBuilder sync() {
        return path -> {
            BuilderCommon<Void> common = new BuilderCommon<Void>(this.filters, BackgroundProcs.ignoredProc);
            SyncBuilderImpl builder = new SyncBuilderImpl(this.client, common.backgrounding);
            return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
        };
    }

    @Override
    public AsyncRemoveWatchesBuilder removeWatches() {
        return new AsyncRemoveWatchesBuilderImpl(this.client, this.filters);
    }

    @Override
    public CuratorFramework unwrap() {
        return this.client;
    }

    @Override
    public WatchableAsyncCuratorFramework watched() {
        return new AsyncCuratorFrameworkImpl(this.client, this.filters, this.watchMode, true);
    }

    @Override
    public AsyncCuratorFrameworkDsl with(WatchMode mode) {
        return new AsyncCuratorFrameworkImpl(this.client, this.filters, mode, this.watched);
    }

    @Override
    public AsyncCuratorFrameworkDsl with(WatchMode mode, UnhandledErrorListener listener, UnaryOperator<CuratorEvent> resultFilter, UnaryOperator<WatchedEvent> watcherFilter) {
        return new AsyncCuratorFrameworkImpl(this.client, new Filters(listener, this.filters.getResultFilter(), this.filters.getWatcherFilter()), mode, this.watched);
    }

    @Override
    public AsyncCuratorFrameworkDsl with(UnhandledErrorListener listener) {
        return new AsyncCuratorFrameworkImpl(this.client, new Filters(listener, this.filters.getResultFilter(), this.filters.getWatcherFilter()), this.watchMode, this.watched);
    }

    @Override
    public AsyncCuratorFrameworkDsl with(UnaryOperator<CuratorEvent> resultFilter, UnaryOperator<WatchedEvent> watcherFilter) {
        return new AsyncCuratorFrameworkImpl(this.client, new Filters(this.filters.getListener(), resultFilter, watcherFilter), this.watchMode, this.watched);
    }

    @Override
    public AsyncCuratorFrameworkDsl with(UnhandledErrorListener listener, UnaryOperator<CuratorEvent> resultFilter, UnaryOperator<WatchedEvent> watcherFilter) {
        return new AsyncCuratorFrameworkImpl(this.client, new Filters(listener, resultFilter, watcherFilter), this.watchMode, this.watched);
    }

    @Override
    public AsyncTransactionOp transactionOp() {
        return new AsyncTransactionOpImpl(this.client);
    }

    @Override
    public AsyncExistsBuilder checkExists() {
        return new AsyncExistsBuilderImpl(this.client, this.filters, this.getBuilderWatchMode());
    }

    @Override
    public AsyncGetDataBuilder getData() {
        return new AsyncGetDataBuilderImpl(this.client, this.filters, this.getBuilderWatchMode());
    }

    @Override
    public AsyncGetChildrenBuilder getChildren() {
        return new AsyncGetChildrenBuilderImpl(this.client, this.filters, this.getBuilderWatchMode());
    }

    @Override
    public AsyncGetConfigBuilder getConfig() {
        return new AsyncGetConfigBuilderImpl(this.client, this.filters, this.getBuilderWatchMode());
    }

    private WatchMode getBuilderWatchMode() {
        return this.watched ? this.watchMode : null;
    }
}

