/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Timing {
    private final long value;
    private final TimeUnit unit;
    private final int waitingMultiple;
    private static final int DEFAULT_SECONDS = 10;
    private static final int DEFAULT_WAITING_MULTIPLE = 5;
    private static final double SESSION_MULTIPLE = 1.5;

    public Timing() {
        this((double)Integer.getInteger("timing-multiple", 1).intValue(), Timing.getWaitingMultiple());
    }

    public Timing(double multiple) {
        this((long)(10.0 * multiple), TimeUnit.SECONDS, Timing.getWaitingMultiple());
    }

    public Timing(double multiple, int waitingMultiple) {
        this((long)(10.0 * multiple), TimeUnit.SECONDS, waitingMultiple);
    }

    public Timing(long value, TimeUnit unit) {
        this(value, unit, Timing.getWaitingMultiple());
    }

    public Timing(long value, TimeUnit unit, int waitingMultiple) {
        this.value = value;
        this.unit = unit;
        this.waitingMultiple = waitingMultiple;
    }

    public int milliseconds() {
        return (int)TimeUnit.MILLISECONDS.convert(this.value, this.unit);
    }

    public int seconds() {
        return (int)this.value;
    }

    public boolean awaitLatch(CountDownLatch latch) {
        Timing m = this.forWaiting();
        try {
            return latch.await(m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean acquireSemaphore(Semaphore semaphore) {
        Timing m = this.forWaiting();
        try {
            return semaphore.tryAcquire(m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean acquireSemaphore(Semaphore semaphore, int n) {
        Timing m = this.forWaiting();
        try {
            return semaphore.tryAcquire(n, m.value, m.unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Timing multiple(double n) {
        return new Timing((int)((double)this.value * n), this.unit);
    }

    public Timing forWaiting() {
        return this.multiple(this.waitingMultiple);
    }

    public void sleepABit() throws InterruptedException {
        this.unit.sleep(this.value / 4L);
    }

    public int session() {
        return this.multiple(1.5).milliseconds();
    }

    public int connection() {
        return this.milliseconds();
    }

    private static Integer getWaitingMultiple() {
        return Integer.getInteger("timing-waiting-multiple", 5);
    }
}

