/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.zookeeper.ZooKeeper;

public class WatchersDebug {
    private static final Method getDataWatches;
    private static final Method getExistWatches;
    private static final Method getChildWatches;

    public static List<String> getDataWatches(ZooKeeper zooKeeper) {
        return WatchersDebug.callMethod(zooKeeper, getDataWatches);
    }

    public static List<String> getExistWatches(ZooKeeper zooKeeper) {
        return WatchersDebug.callMethod(zooKeeper, getExistWatches);
    }

    public static List<String> getChildWatches(ZooKeeper zooKeeper) {
        return WatchersDebug.callMethod(zooKeeper, getChildWatches);
    }

    private WatchersDebug() {
    }

    private static Method getMethod(String name) throws NoSuchMethodException {
        Method m = ZooKeeper.class.getDeclaredMethod(name, new Class[0]);
        m.setAccessible(true);
        return m;
    }

    private static List<String> callMethod(ZooKeeper zooKeeper, Method method) {
        if (zooKeeper == null) {
            return null;
        }
        try {
            return (List)method.invoke((Object)zooKeeper, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method localGetDataWatches = null;
        Method localGetExistWatches = null;
        Method localGetChildWatches = null;
        try {
            localGetDataWatches = WatchersDebug.getMethod("getDataWatches");
            localGetExistWatches = WatchersDebug.getMethod("getExistWatches");
            localGetChildWatches = WatchersDebug.getMethod("getChildWatches");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        getDataWatches = localGetDataWatches;
        getExistWatches = localGetExistWatches;
        getChildWatches = localGetChildWatches;
    }
}

