/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.lang.reflect.Field;
import java.nio.channels.ServerSocketChannel;
import org.apache.curator.test.Compatibility;
import org.apache.curator.test.FailedServerStartException;
import org.apache.curator.test.QuorumConfigBuilder;
import org.apache.curator.test.TestingZooKeeperMain;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestingQuorumPeerMain
extends QuorumPeerMain
implements ZooKeeperMainFace {
    private static final Logger log = LoggerFactory.getLogger(TestingQuorumPeerMain.class);
    private volatile boolean isClosed = false;
    private volatile QuorumConfigBuilder configBuilder;
    private volatile int instanceIndex;

    TestingQuorumPeerMain() {
    }

    @Override
    public void kill() {
        try {
            if (this.quorumPeer != null) {
                Field cnxnFactoryField = QuorumPeer.class.getDeclaredField("cnxnFactory");
                cnxnFactoryField.setAccessible(true);
                ServerCnxnFactory cnxnFactory = (ServerCnxnFactory)cnxnFactoryField.get(this.quorumPeer);
                Compatibility.serverCnxnFactoryCloseAll(cnxnFactory);
                Field ssField = cnxnFactory.getClass().getDeclaredField("ss");
                ssField.setAccessible(true);
                ServerSocketChannel ss = (ServerSocketChannel)ssField.get(cnxnFactory);
                ss.close();
            }
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (this.quorumPeer != null && !this.isClosed) {
            this.isClosed = true;
            this.quorumPeer.shutdown();
        }
    }

    private void blockUntilStarted() {
        long startTime = System.currentTimeMillis();
        while (this.quorumPeer == null && System.currentTimeMillis() - startTime <= (long)TestingZooKeeperMain.MAX_WAIT_MS) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (this.quorumPeer == null) {
            throw new FailedServerStartException("quorumPeer never got set");
        }
    }

    @Override
    public void configure(QuorumConfigBuilder configBuilder, int instanceIndex) {
        this.configBuilder = configBuilder;
        this.instanceIndex = instanceIndex;
    }

    @Override
    public QuorumPeerConfig getConfig() throws Exception {
        if (this.configBuilder != null) {
            return this.configBuilder.buildConfig(this.instanceIndex);
        }
        return null;
    }

    @Override
    public void start() {
        new Thread(() -> {
            try {
                this.runFromConfig(this.getConfig());
            }
            catch (Exception e) {
                log.error("From testing server (random state: {}) for instance: {}", new Object[]{this.configBuilder.isFromRandom(), this.configBuilder.getInstanceSpec(this.instanceIndex), e});
            }
        }).start();
        this.blockUntilStarted();
    }
}

