/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.net.BindException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.test.TestingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener2;
import org.testng.IRetryAnalyzer;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class BaseClassForTests {
    protected volatile TestingServer server;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES;
    private static final String INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND;
    private static final String INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY;

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext context) {
        context.getSuite().addListener((ITestNGListener)new MethodListener(this.log));
    }

    @BeforeMethod
    public void setup() throws Exception {
        if (INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES != null) {
            System.setProperty(INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES, "true");
        }
        System.setProperty(INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND, "true");
        System.setProperty(INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY, "true");
        this.createServer();
    }

    protected void createServer() throws Exception {
        while (this.server == null) {
            try {
                this.server = new TestingServer();
            }
            catch (BindException e) {
                System.err.println("Getting bind exception - retrying to allocate server");
                this.server = null;
            }
        }
    }

    @AfterMethod
    public void teardown() throws Exception {
        System.clearProperty(INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY);
        System.clearProperty(INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND);
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.server = null;
            }
        }
    }

    static {
        String logConnectionIssues = null;
        try {
            Class<?> debugUtilsClazz = Class.forName("org.apache.curator.utils.DebugUtils");
            logConnectionIssues = (String)debugUtilsClazz.getField("PROPERTY_DONT_LOG_CONNECTION_ISSUES").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES = logConnectionIssues;
        String s = null;
        try {
            s = (String)Class.forName("org.apache.curator.utils.DebugUtils").getField("PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_REMOVE_WATCHERS_IN_FOREGROUND = s;
        s = null;
        try {
            s = (String)Class.forName("org.apache.curator.utils.DebugUtils").getField("PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_VALIDATE_NAMESPACE_WATCHER_MAP_EMPTY = s;
    }

    private static class MethodListener
    implements IInvokedMethodListener2 {
        private final Logger log;
        private static final String ATTRIBUTE_NAME = "__curator";

        MethodListener(Logger log) {
            this.log = log;
        }

        public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        }

        public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        }

        public void beforeInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
            RetryContext retryContext;
            if (method.getTestMethod().isBeforeMethodConfiguration()) {
                RetryContext retryContext2 = (RetryContext)context.getAttribute(ATTRIBUTE_NAME);
                if (retryContext2 == null) {
                    retryContext2 = new RetryContext();
                    context.setAttribute(ATTRIBUTE_NAME, (Object)retryContext2);
                }
            } else if (method.isTestMethod() && (retryContext = (RetryContext)context.getAttribute(ATTRIBUTE_NAME)) != null) {
                method.getTestMethod().setRetryAnalyzer((IRetryAnalyzer)new RetryAnalyzer(this.log, retryContext));
            }
        }

        public void afterInvocation(IInvokedMethod method, ITestResult testResult, ITestContext context) {
            if (method.isTestMethod()) {
                RetryContext retryContext = (RetryContext)context.getAttribute(ATTRIBUTE_NAME);
                if (retryContext == null) {
                    this.log.error("No retryContext!");
                } else if (testResult.isSuccess() || testResult.getStatus() == 2) {
                    retryContext.isRetrying.set(false);
                    if (retryContext.runVersion.incrementAndGet() > 1) {
                        context.setAttribute(ATTRIBUTE_NAME, null);
                    }
                }
            }
        }
    }

    private static class RetryAnalyzer
    implements IRetryAnalyzer {
        private final Logger log;
        private final RetryContext retryContext;

        RetryAnalyzer(Logger log, RetryContext retryContext) {
            this.log = log;
            this.retryContext = Objects.requireNonNull(retryContext, "retryContext cannot be null");
        }

        public boolean retry(ITestResult result) {
            if (result.isSuccess() || this.retryContext.isRetrying.get()) {
                this.retryContext.isRetrying.set(false);
                return false;
            }
            result.setStatus(3);
            if (result.getThrowable() != null) {
                this.log.error("Retrying 1 time", result.getThrowable());
            } else {
                this.log.error("Retrying 1 time");
            }
            this.retryContext.isRetrying.set(true);
            return true;
        }
    }

    private static class RetryContext {
        final AtomicBoolean isRetrying = new AtomicBoolean(false);
        final AtomicInteger runVersion = new AtomicInteger(0);

        private RetryContext() {
        }
    }
}

