/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.test.Timing;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class KillServerSession {
    public static void kill(ZooKeeper client, String connectString) throws Exception {
        KillServerSession.kill(client, connectString, new Timing().forWaiting().milliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void kill(ZooKeeper client, String connectString, int maxMs) throws Exception {
        long startTicks = System.currentTimeMillis();
        final CountDownLatch sessionLostLatch = new CountDownLatch(1);
        Watcher sessionLostWatch = new Watcher(){

            public void process(WatchedEvent event) {
                sessionLostLatch.countDown();
            }
        };
        client.exists("/___CURATOR_KILL_SESSION___" + System.nanoTime(), sessionLostWatch);
        final CountDownLatch connectionLatch = new CountDownLatch(1);
        Watcher connectionWatcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    connectionLatch.countDown();
                }
            }
        };
        try (ZooKeeper zk = new ZooKeeper(connectString, maxMs, connectionWatcher, client.getSessionId(), client.getSessionPasswd());){
            if (!connectionLatch.await(maxMs, TimeUnit.MILLISECONDS)) {
                throw new Exception("KillSession could not establish duplicate session");
            }
            try {
                zk.close();
            }
            finally {
                zk = null;
            }
            while (client.getState().isConnected() && !sessionLostLatch.await(100L, TimeUnit.MILLISECONDS)) {
                long elapsed = System.currentTimeMillis() - startTicks;
                if (elapsed <= (long)maxMs) continue;
                throw new Exception("KillSession timed out waiting for session to expire");
            }
        }
    }
}

