/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CountDownLatch;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class TestingZooKeeperMain
extends ZooKeeperServerMain
implements ZooKeeperMainFace {
    private final CountDownLatch latch = new CountDownLatch(1);
    private static final int MAX_WAIT_MS = 1000;

    @Override
    public void kill() {
        try {
            Field cnxnFactoryField = ZooKeeperServerMain.class.getDeclaredField("cnxnFactory");
            cnxnFactoryField.setAccessible(true);
            ServerCnxnFactory cnxnFactory = (ServerCnxnFactory)cnxnFactoryField.get(this);
            cnxnFactory.closeAll();
            Field ssField = cnxnFactory.getClass().getDeclaredField("ss");
            ssField.setAccessible(true);
            ServerSocketChannel ss = (ServerSocketChannel)ssField.get(cnxnFactory);
            ss.close();
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void runFromConfig(QuorumPeerConfig config) throws Exception {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.readFrom(config);
        this.latch.countDown();
        super.runFromConfig(serverConfig);
    }

    @Override
    public QuorumPeer getQuorumPeer() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockUntilStarted() throws Exception {
        ZooKeeperServer zkServer;
        this.latch.await();
        ServerCnxnFactory cnxnFactory = this.getServerConnectionFactory();
        if (cnxnFactory != null && (zkServer = this.getZooKeeperServer(cnxnFactory)) != null) {
            ZooKeeperServer zooKeeperServer = zkServer;
            synchronized (zooKeeperServer) {
                if (!zkServer.isRunning()) {
                    zkServer.wait();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
        try {
            ZKDatabase zkDb;
            ZooKeeperServer zkServer;
            ServerCnxnFactory cnxnFactory = this.getServerConnectionFactory();
            if (cnxnFactory != null && (zkServer = this.getZooKeeperServer(cnxnFactory)) != null && (zkDb = zkServer.getZKDatabase()) != null) {
                zkDb.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ServerCnxnFactory getServerConnectionFactory() throws Exception {
        ServerCnxnFactory cnxnFactory;
        Field cnxnFactoryField = ZooKeeperServerMain.class.getDeclaredField("cnxnFactory");
        cnxnFactoryField.setAccessible(true);
        long startTime = System.currentTimeMillis();
        while ((cnxnFactory = (ServerCnxnFactory)cnxnFactoryField.get(this)) == null && System.currentTimeMillis() - startTime < 1000L) {
        }
        return cnxnFactory;
    }

    private ZooKeeperServer getZooKeeperServer(ServerCnxnFactory cnxnFactory) throws Exception {
        ZooKeeperServer zkServer;
        Field zkServerField = ServerCnxnFactory.class.getDeclaredField("zkServer");
        zkServerField.setAccessible(true);
        long startTime = System.currentTimeMillis();
        while ((zkServer = (ZooKeeperServer)zkServerField.get(cnxnFactory)) == null && System.currentTimeMillis() - startTime < 1000L) {
        }
        return zkServer;
    }
}

