/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class TestingZooKeeperMain
extends ZooKeeperServerMain
implements ZooKeeperMainFace {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Exception> startingException = new AtomicReference<Object>(null);
    private static final int MAX_WAIT_MS;

    @Override
    public void kill() {
        try {
            Field cnxnFactoryField = ZooKeeperServerMain.class.getDeclaredField("cnxnFactory");
            cnxnFactoryField.setAccessible(true);
            ServerCnxnFactory cnxnFactory = (ServerCnxnFactory)cnxnFactoryField.get(this);
            cnxnFactory.closeAll();
            Field ssField = cnxnFactory.getClass().getDeclaredField("ss");
            ssField.setAccessible(true);
            ServerSocketChannel ss = (ServerSocketChannel)ssField.get(cnxnFactory);
            ss.close();
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void runFromConfig(QuorumPeerConfig config) throws Exception {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.readFrom(config);
        this.latch.countDown();
        try {
            super.runFromConfig(serverConfig);
        }
        catch (IOException e) {
            this.startingException.set(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockUntilStarted() throws Exception {
        ZooKeeperServer zkServer;
        this.latch.await();
        ServerCnxnFactory cnxnFactory = this.getServerConnectionFactory();
        if (cnxnFactory != null && (zkServer = this.getZooKeeperServer(cnxnFactory)) != null) {
            ZooKeeperServer zooKeeperServer = zkServer;
            synchronized (zooKeeperServer) {
                if (!zkServer.isRunning()) {
                    zkServer.wait();
                }
            }
        }
        Thread.sleep(1000L);
        Exception exception = this.startingException.get();
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            ZKDatabase zkDb;
            ZooKeeperServer zkServer;
            ServerCnxnFactory cnxnFactory = this.getServerConnectionFactory();
            if (cnxnFactory != null && (zkServer = this.getZooKeeperServer(cnxnFactory)) != null && (zkDb = zkServer.getZKDatabase()) != null) {
                zkDb.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ServerCnxnFactory getServerConnectionFactory() throws Exception {
        ServerCnxnFactory cnxnFactory;
        Field cnxnFactoryField = ZooKeeperServerMain.class.getDeclaredField("cnxnFactory");
        cnxnFactoryField.setAccessible(true);
        long startTime = System.currentTimeMillis();
        while ((cnxnFactory = (ServerCnxnFactory)cnxnFactoryField.get(this)) == null && System.currentTimeMillis() - startTime < (long)MAX_WAIT_MS) {
        }
        return cnxnFactory;
    }

    private ZooKeeperServer getZooKeeperServer(ServerCnxnFactory cnxnFactory) throws Exception {
        ZooKeeperServer zkServer;
        Field zkServerField = ServerCnxnFactory.class.getDeclaredField("zkServer");
        zkServerField.setAccessible(true);
        long startTime = System.currentTimeMillis();
        while ((zkServer = (ZooKeeperServer)zkServerField.get(cnxnFactory)) == null && System.currentTimeMillis() - startTime < (long)MAX_WAIT_MS) {
        }
        return zkServer;
    }

    static {
        long startMs = System.currentTimeMillis();
        try {
            InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        long elapsed = System.currentTimeMillis() - startMs;
        MAX_WAIT_MS = Math.max((int)elapsed * 2, 1000);
    }
}

