/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.net.BindException;
import org.apache.curator.test.TestingServer;
import org.testng.IRetryAnalyzer;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class BaseClassForTests {
    protected TestingServer server;
    private static final String INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES;

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext context) {
        for (ITestNGMethod method : context.getAllTestMethods()) {
            method.setRetryAnalyzer((IRetryAnalyzer)new RetryTest());
        }
    }

    @BeforeMethod
    public void setup() throws Exception {
        if (INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES != null) {
            System.setProperty(INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES, "true");
        }
        while (this.server == null) {
            try {
                this.server = new TestingServer();
            }
            catch (BindException e) {
                System.err.println("Getting bind exception - retrying to allocate server");
                this.server = null;
            }
        }
    }

    @AfterMethod
    public void teardown() throws Exception {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.server = null;
        }
    }

    static {
        String logConnectionIssues = null;
        Object retryFailedTests = null;
        try {
            Class<?> debugUtilsClazz = Class.forName("org.apache.curator.utils.DebugUtils");
            logConnectionIssues = (String)debugUtilsClazz.getField("PROPERTY_DONT_LOG_CONNECTION_ISSUES").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INTERNAL_PROPERTY_DONT_LOG_CONNECTION_ISSUES = logConnectionIssues;
    }

    private static class RetryTest
    implements IRetryAnalyzer {
        private boolean wasRetried = false;

        private RetryTest() {
        }

        public boolean retry(ITestResult result) {
            if (result.isSuccess() || this.wasRetried) {
                this.wasRetried = false;
                return false;
            }
            this.wasRetried = true;
            System.err.println(String.format("Retry test 1 time. Name: %s - TestName: %s ", result.getName(), result.getTestName()));
            return true;
        }
    }
}

