/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.zookeeper.server.ZooKeeperServer;

class ServerHelper {
    private static final ServerCnxnFactoryMethods serverCnxnFactoryMethods;
    private static final NioServerCnxnMethods nioServerCnxn;

    static Object makeFactory(ZooKeeperServer server, int port) throws Exception {
        Object factory;
        if (nioServerCnxn != null) {
            factory = nioServerCnxn.constructor.newInstance(new InetSocketAddress(port));
            if (server != null) {
                nioServerCnxn.startupMethod.invoke(factory, server);
            }
        } else {
            factory = serverCnxnFactoryMethods.constructor.newInstance(new Object[0]);
            serverCnxnFactoryMethods.configureMethod.invoke(factory, new InetSocketAddress(port), 0);
            if (server != null) {
                serverCnxnFactoryMethods.startupMethod.invoke(factory, server);
            }
        }
        return factory;
    }

    static void shutdownFactory(Object factory) {
        try {
            if (nioServerCnxn != null) {
                nioServerCnxn.shutdownMethod.invoke(factory, new Object[0]);
            } else {
                serverCnxnFactoryMethods.shutdownMethod.invoke(factory, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private ServerHelper() {
    }

    static {
        Class<?> serverCnxnFactoryClass = null;
        Class<?> nioServerCnxnFactoryClass = null;
        try {
            serverCnxnFactoryClass = Class.forName("org.apache.zookeeper.server.NIOServerCnxnFactory");
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        try {
            nioServerCnxnFactoryClass = Class.forName("org.apache.zookeeper.server.NIOServerCnxn$Factory");
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        ServerCnxnFactoryMethods localServerCnxnFactoryMethods = null;
        NioServerCnxnMethods localNioServerCnxn = null;
        try {
            if (serverCnxnFactoryClass != null) {
                localServerCnxnFactoryMethods = new ServerCnxnFactoryMethods(serverCnxnFactoryClass.getConstructor(new Class[0]), serverCnxnFactoryClass.getDeclaredMethod("configure", InetSocketAddress.class, Integer.TYPE), serverCnxnFactoryClass.getDeclaredMethod("startup", ZooKeeperServer.class), serverCnxnFactoryClass.getDeclaredMethod("shutdown", new Class[0]));
            } else if (nioServerCnxnFactoryClass != null) {
                localNioServerCnxn = new NioServerCnxnMethods(nioServerCnxnFactoryClass.getConstructor(InetSocketAddress.class), nioServerCnxnFactoryClass.getDeclaredMethod("startup", ZooKeeperServer.class), nioServerCnxnFactoryClass.getDeclaredMethod("shutdown", new Class[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
        serverCnxnFactoryMethods = localServerCnxnFactoryMethods;
        nioServerCnxn = localNioServerCnxn;
    }

    private static class NioServerCnxnMethods {
        private final Constructor constructor;
        private final Method startupMethod;
        private final Method shutdownMethod;

        private NioServerCnxnMethods(Constructor constructor, Method startupMethod, Method shutdownMethod) {
            this.constructor = constructor;
            this.startupMethod = startupMethod;
            this.shutdownMethod = shutdownMethod;
        }
    }

    private static class ServerCnxnFactoryMethods {
        private final Constructor constructor;
        private final Method configureMethod;
        private final Method startupMethod;
        private final Method shutdownMethod;

        private ServerCnxnFactoryMethods(Constructor constructor, Method configureMethod, Method startupMethod, Method shutdownMethod) {
            this.constructor = constructor;
            this.configureMethod = configureMethod;
            this.startupMethod = startupMethod;
            this.shutdownMethod = shutdownMethod;
        }
    }
}

