/*
 * Decompiled with CFR 0.152.
 */
package locking;

import java.util.concurrent.TimeUnit;
import locking.FakeLimitedResource;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;

public class ExampleClientThatLocks {
    private final InterProcessMutex lock;
    private final FakeLimitedResource resource;
    private final String clientName;

    public ExampleClientThatLocks(CuratorFramework client, String lockPath, FakeLimitedResource resource, String clientName) {
        this.resource = resource;
        this.clientName = clientName;
        this.lock = new InterProcessMutex(client, lockPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(long time, TimeUnit unit) throws Exception {
        if (!this.lock.acquire(time, unit)) {
            throw new IllegalStateException(this.clientName + " could not acquire the lock");
        }
        try {
            System.out.println(this.clientName + " has the lock");
            this.resource.use();
        }
        finally {
            System.out.println(this.clientName + " releasing the lock");
            this.lock.release();
        }
    }
}

