/*
 * Decompiled with CFR 0.152.
 */
package pubsub;

import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.modeled.cached.CachedModeledFramework;
import org.apache.curator.x.async.modeled.typed.TypedModeledFramework2;
import pubsub.Clients;
import pubsub.messages.LocationAvailable;
import pubsub.messages.UserCreated;
import pubsub.models.Group;
import pubsub.models.Instance;
import pubsub.models.InstanceType;
import pubsub.models.Message;
import pubsub.models.Priority;

public class Subscriber {
    private final AsyncCuratorFramework client;

    public Subscriber(AsyncCuratorFramework client) {
        this.client = client;
    }

    public CachedModeledFramework<LocationAvailable> startLocationAvailableSubscriber(Group group, Priority priority) {
        return this.startSubscriber(Clients.locationAvailableClient, group, priority);
    }

    public CachedModeledFramework<UserCreated> startUserCreatedSubscriber(Group group, Priority priority) {
        return this.startSubscriber(Clients.userCreatedClient, group, priority);
    }

    public CachedModeledFramework<Instance> startInstanceSubscriber(InstanceType instanceType) {
        CachedModeledFramework resolved = Clients.instanceClient.resolved(this.client, (Object)instanceType).cached();
        resolved.start();
        return resolved;
    }

    private <T extends Message> CachedModeledFramework<T> startSubscriber(TypedModeledFramework2<T, Group, Priority> typedClient, Group group, Priority priority) {
        CachedModeledFramework resolved = typedClient.resolved(this.client, (Object)group, (Object)priority).cached();
        resolved.start();
        return resolved;
    }
}

