/*
 * Decompiled with CFR 0.152.
 */
package pubsub.models;

import java.util.Objects;
import java.util.UUID;
import org.apache.curator.x.async.modeled.NodeName;
import pubsub.models.Priority;

public abstract class Message
implements NodeName {
    private final String id;
    private final Priority priority;

    protected Message() {
        this(UUID.randomUUID().toString(), Priority.low);
    }

    protected Message(Priority priority) {
        this(UUID.randomUUID().toString(), priority);
    }

    protected Message(String id, Priority priority) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.priority = Objects.requireNonNull(priority, "messageType cannot be null");
    }

    public String getId() {
        return this.id;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String nodeName() {
        return this.id;
    }

    public String toString() {
        return "Message{id='" + this.id + '\'' + ", priority=" + (Object)((Object)this.priority) + '}';
    }
}

