/*
 * Decompiled with CFR 0.152.
 */
package pubsub.models;

import java.util.Objects;
import java.util.UUID;
import org.apache.curator.x.async.modeled.NodeName;
import pubsub.models.InstanceType;

public class Instance
implements NodeName {
    private final String id;
    private final InstanceType type;
    private final String hostname;
    private final int port;

    public Instance() {
        this(UUID.randomUUID().toString(), InstanceType.proxy, "", 0);
    }

    public Instance(String id, InstanceType type, String hostname, int port) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.hostname = Objects.requireNonNull(hostname, "hostname cannot be null");
        this.port = port;
    }

    public String getId() {
        return this.id;
    }

    public InstanceType getType() {
        return this.type;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String nodeName() {
        return this.id;
    }

    public String toString() {
        return "Instance{id='" + this.id + '\'' + ", type=" + (Object)((Object)this.type) + ", hostname='" + this.hostname + '\'' + ", port=" + this.port + '}';
    }
}

