/*
 * Decompiled with CFR 0.152.
 */
package framework;

import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;

public class CrudExamples {
    public static void create(CuratorFramework client, String path, byte[] payload) throws Exception {
        client.create().forPath(path, payload);
    }

    public static void createEphemeral(CuratorFramework client, String path, byte[] payload) throws Exception {
        ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).forPath(path, payload);
    }

    public static String createEphemeralSequential(CuratorFramework client, String path, byte[] payload) throws Exception {
        return (String)((ACLBackgroundPathAndBytesable)client.create().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path, payload);
    }

    public static void setData(CuratorFramework client, String path, byte[] payload) throws Exception {
        client.setData().forPath(path, payload);
    }

    public static void setDataAsync(CuratorFramework client, String path, byte[] payload) throws Exception {
        CuratorListener listener = new CuratorListener(){

            public void eventReceived(CuratorFramework client, CuratorEvent event) throws Exception {
            }
        };
        client.getCuratorListenable().addListener((Object)listener);
        ((ErrorListenerPathAndBytesable)client.setData().inBackground()).forPath(path, payload);
    }

    public static void setDataAsyncWithCallback(CuratorFramework client, BackgroundCallback callback, String path, byte[] payload) throws Exception {
        ((ErrorListenerPathAndBytesable)client.setData().inBackground(callback)).forPath(path, payload);
    }

    public static void delete(CuratorFramework client, String path) throws Exception {
        client.delete().forPath(path);
    }

    public static void guaranteedDelete(CuratorFramework client, String path) throws Exception {
        ((ChildrenDeletable)client.delete().guaranteed()).forPath(path);
    }

    public static List<String> watchedGetChildren(CuratorFramework client, String path) throws Exception {
        return (List)((BackgroundPathable)client.getChildren().watched()).forPath(path);
    }

    public static List<String> watchedGetChildren(CuratorFramework client, String path, Watcher watcher) throws Exception {
        return (List)((BackgroundPathable)client.getChildren().usingWatcher(watcher)).forPath(path);
    }
}

