/*
 * Decompiled with CFR 0.152.
 */
package pubsub;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.test.TestingServer;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.modeled.cached.CachedModeledFramework;
import org.apache.curator.x.async.modeled.cached.ModeledCacheListener;
import pubsub.Publisher;
import pubsub.Subscriber;
import pubsub.messages.LocationAvailable;
import pubsub.messages.UserCreated;
import pubsub.models.Group;
import pubsub.models.Instance;
import pubsub.models.InstanceType;
import pubsub.models.Priority;

public class SubPubTest
implements Closeable {
    private final TestingServer testingServer;
    private final AsyncCuratorFramework client;
    private final ScheduledExecutorService executorService;
    private final List<CachedModeledFramework<Instance>> instanceSubscribers = new ArrayList<CachedModeledFramework<Instance>>();
    private final List<CachedModeledFramework<LocationAvailable>> locationAvailableSubscribers = new ArrayList<CachedModeledFramework<LocationAvailable>>();
    private final List<CachedModeledFramework<UserCreated>> userCreatedSubscribers = new ArrayList<CachedModeledFramework<UserCreated>>();
    private static final AtomicLong nextId = new AtomicLong(1L);
    private static final Group[] groups = new Group[]{new Group("main"), new Group("admin")};
    private static final String[] hostnames = new String[]{"host1", "host2", "host3"};
    private static final Integer[] ports = new Integer[]{80, 443, 9999};
    private static final String[] locations = new String[]{"dc1", "dc2", "eu", "us"};
    private static final Duration[] durations = new Duration[]{Duration.ofSeconds(1L), Duration.ofMinutes(1L), Duration.ofHours(1L)};
    private static final String[] positions = new String[]{"worker", "manager", "executive"};

    public static void main(String[] args) {
        try (SubPubTest subPubTest = new SubPubTest();){
            subPubTest.start();
            TimeUnit.MINUTES.sleep(1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SubPubTest() throws Exception {
        this.testingServer = new TestingServer();
        this.client = AsyncCuratorFramework.wrap((CuratorFramework)CuratorFrameworkFactory.newClient((String)this.testingServer.getConnectString(), (RetryPolicy)new RetryOneTime(1)));
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void start() {
        this.client.unwrap().start();
        Publisher publisher = new Publisher(this.client);
        Subscriber subscriber = new Subscriber(this.client);
        this.instanceSubscribers.addAll(Arrays.stream(InstanceType.values()).map(subscriber::startInstanceSubscriber).collect(Collectors.toList()));
        this.locationAvailableSubscribers.addAll(Arrays.stream(Priority.values()).flatMap(priority -> Arrays.stream(groups).map(group -> subscriber.startLocationAvailableSubscriber((Group)group, (Priority)((Object)priority)))).collect(Collectors.toList()));
        this.userCreatedSubscribers.addAll(Arrays.stream(Priority.values()).flatMap(priority -> Arrays.stream(groups).map(group -> subscriber.startUserCreatedSubscriber((Group)group, (Priority)((Object)priority)))).collect(Collectors.toList()));
        this.instanceSubscribers.forEach(s -> s.listenable().addListener(this.generalListener()));
        this.locationAvailableSubscribers.forEach(s -> s.listenable().addListener(this.generalListener()));
        this.userCreatedSubscribers.forEach(s -> s.listenable().addListener(this.generalListener()));
        this.executorService.scheduleAtFixedRate(() -> this.publishSomething(publisher), 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        this.userCreatedSubscribers.forEach(CachedModeledFramework::close);
        this.locationAvailableSubscribers.forEach(CachedModeledFramework::close);
        this.instanceSubscribers.forEach(CachedModeledFramework::close);
        this.client.unwrap().close();
        this.testingServer.close();
    }

    private void publishSomething(Publisher publisher) {
        switch (ThreadLocalRandom.current().nextInt(6)) {
            case 0: {
                Instance instance = new Instance(this.nextId(), this.random(InstanceType.values()), this.random(hostnames), this.random(ports));
                System.out.println("Publishing 1 instance");
                publisher.publishInstance(instance);
                break;
            }
            case 1: {
                List<Instance> instances = IntStream.range(1, 10).mapToObj(__ -> new Instance(this.nextId(), this.random(InstanceType.values()), this.random(hostnames), this.random(ports))).collect(Collectors.toList());
                System.out.println(String.format("Publishing %d instances", instances.size()));
                publisher.publishInstances(instances);
                break;
            }
            case 2: {
                LocationAvailable locationAvailable = new LocationAvailable(this.nextId(), this.random(Priority.values()), this.random(locations), this.random(durations));
                System.out.println("Publishing 1 locationAvailable");
                publisher.publishLocationAvailable(this.random(groups), locationAvailable);
                break;
            }
            case 3: {
                List<LocationAvailable> locationsAvailable = IntStream.range(1, 10).mapToObj(__ -> new LocationAvailable(this.nextId(), this.random(Priority.values()), this.random(locations), this.random(durations))).collect(Collectors.toList());
                System.out.println(String.format("Publishing %d locationsAvailable", locationsAvailable.size()));
                publisher.publishLocationsAvailable(this.random(groups), locationsAvailable);
                break;
            }
            case 4: {
                UserCreated userCreated = new UserCreated(this.nextId(), this.random(Priority.values()), this.random(locations), this.random(positions));
                System.out.println("Publishing 1 userCreated");
                publisher.publishUserCreated(this.random(groups), userCreated);
                break;
            }
            case 5: {
                List<UserCreated> usersCreated = IntStream.range(1, 10).mapToObj(__ -> new UserCreated(this.nextId(), this.random(Priority.values()), this.random(locations), this.random(positions))).collect(Collectors.toList());
                System.out.println(String.format("Publishing %d usersCreated", usersCreated.size()));
                publisher.publishUsersCreated(this.random(groups), usersCreated);
                break;
            }
        }
    }

    private <T> ModeledCacheListener<T> generalListener() {
        return (type, path, stat, model) -> System.out.println(String.format("Subscribed %s @ %s", model.getClass().getSimpleName(), path));
    }

    @SafeVarargs
    private final <T> T random(T ... tab) {
        int index = ThreadLocalRandom.current().nextInt(tab.length);
        return tab[index];
    }

    private String nextId() {
        return Long.toString(nextId.getAndIncrement());
    }
}

