/*
 * Decompiled with CFR 0.152.
 */
package async;

import java.util.concurrent.CompletionStage;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncEventException;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.WatchMode;
import org.apache.zookeeper.WatchedEvent;

public class AsyncExamples {
    public static AsyncCuratorFramework wrap(CuratorFramework client) {
        return AsyncCuratorFramework.wrap((CuratorFramework)client);
    }

    public static void create(CuratorFramework client, String path, byte[] payload) {
        AsyncCuratorFramework async = AsyncCuratorFramework.wrap((CuratorFramework)client);
        ((AsyncStage)async.create().forPath(path, payload)).whenComplete((name, exception) -> {
            if (exception != null) {
                exception.printStackTrace();
            } else {
                System.out.println("Created node name is: " + name);
            }
        });
    }

    public static void createThenWatch(CuratorFramework client, String path) {
        AsyncCuratorFramework async = AsyncCuratorFramework.wrap((CuratorFramework)client);
        ((AsyncStage)async.create().forPath(path)).whenComplete((name, exception) -> {
            if (exception != null) {
                exception.printStackTrace();
            } else {
                AsyncExamples.handleWatchedStage(((AsyncStage)async.watched().checkExists().forPath(path)).event());
            }
        });
    }

    public static void createThenWatchSimple(CuratorFramework client, String path) {
        AsyncCuratorFramework async = AsyncCuratorFramework.wrap((CuratorFramework)client);
        ((AsyncStage)async.create().forPath(path)).whenComplete((name, exception) -> {
            if (exception != null) {
                exception.printStackTrace();
            } else {
                ((AsyncStage)async.with(WatchMode.successOnly).watched().checkExists().forPath(path)).event().thenAccept(event -> {
                    System.out.println(event.getType());
                    System.out.println(event);
                });
            }
        });
    }

    private static void handleWatchedStage(CompletionStage<WatchedEvent> watchedStage) {
        watchedStage.thenAccept(event -> {
            System.out.println(event.getType());
            System.out.println(event);
        });
        watchedStage.exceptionally(exception -> {
            AsyncEventException asyncEx = (AsyncEventException)exception;
            asyncEx.printStackTrace();
            AsyncExamples.handleWatchedStage(asyncEx.reset());
            return null;
        });
    }
}

