/*
 * Decompiled with CFR 0.152.
 */
package modeled;

import java.util.Objects;
import modeled.ContainerType;
import modeled.PersonId;

public class PersonModel {
    private final PersonId id;
    private final ContainerType containerType;
    private final String firstName;
    private final String lastName;
    private final int age;

    public PersonModel() {
        this(new PersonId(), new ContainerType(), null, null, 0);
    }

    public PersonModel(PersonId id, ContainerType containerType, String firstName, String lastName, int age) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.containerType = Objects.requireNonNull(containerType, "containerType cannot be null");
        this.firstName = Objects.requireNonNull(firstName, "firstName cannot be null");
        this.lastName = Objects.requireNonNull(lastName, "lastName cannot be null");
        this.age = age;
    }

    public PersonId getId() {
        return this.id;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public int getAge() {
        return this.age;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonModel that = (PersonModel)o;
        if (this.age != that.age) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.containerType.equals(that.containerType)) {
            return false;
        }
        if (!this.firstName.equals(that.firstName)) {
            return false;
        }
        return this.lastName.equals(that.lastName);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.containerType.hashCode();
        result = 31 * result + this.firstName.hashCode();
        result = 31 * result + this.lastName.hashCode();
        result = 31 * result + this.age;
        return result;
    }

    public String toString() {
        return "PersonModel{id=" + this.id + ", containerType=" + this.containerType + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", age=" + this.age + '}';
    }
}

