/*
 * Decompiled with CFR 0.152.
 */
package locking;

import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import locking.ExampleClientThatLocks;
import locking.FakeLimitedResource;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.curator.utils.CloseableUtils;

public class LockingExample {
    private static final int QTY = 5;
    private static final int REPETITIONS = 50;
    private static final String PATH = "/examples/locks";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final FakeLimitedResource resource = new FakeLimitedResource();
        ExecutorService service = Executors.newFixedThreadPool(5);
        final TestingServer server = new TestingServer();
        try {
            int i = 0;
            while (i < 5) {
                final int index = i++;
                Callable<Void> task = new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        CuratorFramework client = CuratorFrameworkFactory.newClient((String)server.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
                        try {
                            client.start();
                            ExampleClientThatLocks example = new ExampleClientThatLocks(client, LockingExample.PATH, resource, "Client " + index);
                            for (int j = 0; j < 50; ++j) {
                                example.doWork(10L, TimeUnit.SECONDS);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            CloseableUtils.closeQuietly((Closeable)client);
                        }
                        return null;
                    }
                };
                service.submit(task);
            }
            service.shutdown();
            service.awaitTermination(10L, TimeUnit.MINUTES);
        }
        finally {
            CloseableUtils.closeQuietly((Closeable)server);
        }
    }
}

