/*
 * Decompiled with CFR 0.152.
 */
package leader;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.ArrayList;
import leader.ExampleClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;

public class LeaderSelectorExample {
    private static final int CLIENT_QTY = 10;
    private static final String PATH = "/examples/leader";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Create 10 clients, have each negotiate for leadership and then wait a random number of seconds before letting another leader election occur.");
        System.out.println("Notice that leader election is fair: all clients will become leader and will do so the same number of times.");
        ArrayList clients = Lists.newArrayList();
        ArrayList examples = Lists.newArrayList();
        TestingServer server = new TestingServer();
        try {
            for (int i = 0; i < 10; ++i) {
                CuratorFramework client = CuratorFrameworkFactory.newClient((String)server.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
                clients.add(client);
                ExampleClient example = new ExampleClient(client, PATH, "Client #" + i);
                examples.add(example);
                client.start();
                example.start();
            }
            System.out.println("Press enter/return to quit\n");
            new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        finally {
            System.out.println("Shutting down...");
            for (ExampleClient exampleClient : examples) {
                Closeables.closeQuietly((Closeable)exampleClient);
            }
            for (CuratorFramework client : clients) {
                Closeables.closeQuietly((Closeable)client);
            }
            Closeables.closeQuietly((Closeable)server);
        }
    }
}

