/*
 * Decompiled with CFR 0.152.
 */
package discovery;

import com.google.common.io.Closeables;
import discovery.InstanceDetails;
import java.io.Closeable;
import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.UriSpec;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;

public class ExampleServer
implements Closeable {
    private final ServiceDiscovery<InstanceDetails> serviceDiscovery;
    private final ServiceInstance<InstanceDetails> thisInstance;

    public ExampleServer(CuratorFramework client, String path, String serviceName, String description) throws Exception {
        UriSpec uriSpec = new UriSpec("{scheme}://foo.com:{port}");
        this.thisInstance = ServiceInstance.builder().name(serviceName).payload((Object)new InstanceDetails(description)).port((int)(65535.0 * Math.random())).uriSpec(uriSpec).build();
        JsonInstanceSerializer serializer = new JsonInstanceSerializer(InstanceDetails.class);
        this.serviceDiscovery = ServiceDiscoveryBuilder.builder(InstanceDetails.class).client(client).basePath(path).serializer((InstanceSerializer)serializer).thisInstance(this.thisInstance).build();
    }

    public ServiceInstance<InstanceDetails> getThisInstance() {
        return this.thisInstance;
    }

    public void start() throws Exception {
        this.serviceDiscovery.start();
    }

    @Override
    public void close() throws IOException {
        Closeables.closeQuietly(this.serviceDiscovery);
    }
}

