/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.simple.internal.Seed2ArrayConverter;

public class Long2IntArray
implements Seed2ArrayConverter<Long, int[]> {
    private final int size;

    public Long2IntArray(int size) {
        this.size = size;
    }

    @Override
    public int[] convert(Long seed) {
        return Long2IntArray.convertSeed(seed, this.size);
    }

    @Override
    public int[] convert(Long seed, int outputSize) {
        return Long2IntArray.convertSeed(seed, outputSize);
    }

    private static int[] convertSeed(Long seed, int size) {
        int[] out = new int[size];
        SplitMix64 rng = new SplitMix64(seed);
        for (int i = size - 1; i > 0; i -= 2) {
            long v = rng.nextLong();
            out[i] = NumberFactory.extractHi((long)v);
            out[i - 1] = NumberFactory.extractLo((long)v);
        }
        if ((size & 1) == 1) {
            out[0] = NumberFactory.extractHi((long)rng.nextLong());
        }
        return out;
    }
}

