/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import java.util.EnumMap;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public final class ThreadLocalRandomSource {
    private static EnumMap<RandomSource, ThreadLocal<UniformRandomProvider>> sources = new EnumMap(RandomSource.class);

    private ThreadLocalRandomSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniformRandomProvider current(RandomSource source) {
        ThreadLocalRng rng = sources.get((Object)source);
        if (rng == null) {
            if (source == null) {
                throw new IllegalArgumentException("Random source is null");
            }
            EnumMap<RandomSource, ThreadLocal<UniformRandomProvider>> enumMap = sources;
            synchronized (enumMap) {
                rng = sources.get((Object)source);
                if (rng == null) {
                    rng = new ThreadLocalRng(source);
                    sources.put(source, rng);
                }
            }
        }
        return rng.get();
    }

    private static class ThreadLocalRng
    extends ThreadLocal<UniformRandomProvider> {
        private final RandomSource source;

        ThreadLocalRng(RandomSource source) {
            this.source = source;
        }

        @Override
        protected UniformRandomProvider initialValue() {
            return RandomSource.create(this.source);
        }
    }
}

