/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class InverseTransformParetoSampler
extends SamplerBase
implements SharedStateContinuousSampler {
    private final double scale;
    private final double oneOverShape;
    private final UniformRandomProvider rng;

    public InverseTransformParetoSampler(UniformRandomProvider rng, double scale, double shape) {
        super(null);
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale is not strictly positive: " + scale);
        }
        if (shape <= 0.0) {
            throw new IllegalArgumentException("shape is not strictly positive: " + shape);
        }
        this.rng = rng;
        this.scale = scale;
        this.oneOverShape = 1.0 / shape;
    }

    private InverseTransformParetoSampler(UniformRandomProvider rng, InverseTransformParetoSampler source) {
        super(null);
        this.rng = rng;
        this.scale = source.scale;
        this.oneOverShape = source.oneOverShape;
    }

    @Override
    public double sample() {
        return this.scale / Math.pow(this.rng.nextDouble(), this.oneOverShape);
    }

    @Override
    public String toString() {
        return "[Inverse method for Pareto distribution " + this.rng.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new InverseTransformParetoSampler(rng, this);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, double scale, double shape) {
        return new InverseTransformParetoSampler(rng, scale, shape);
    }
}

