/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class ContinuousUniformSampler
extends SamplerBase
implements SharedStateContinuousSampler {
    private final double lo;
    private final double hi;
    private final UniformRandomProvider rng;

    public ContinuousUniformSampler(UniformRandomProvider rng, double lo, double hi) {
        super(null);
        this.rng = rng;
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public double sample() {
        double u = this.rng.nextDouble();
        return u * this.hi + (1.0 - u) * this.lo;
    }

    @Override
    public String toString() {
        return "Uniform deviate [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new ContinuousUniformSampler(rng, this.lo, this.hi);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, double lo, double hi) {
        return new ContinuousUniformSampler(rng, lo, hi);
    }
}

