/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class DiscreteUniformSampler
extends SamplerBase
implements DiscreteSampler {
    private final int lower;
    private final int upper;

    public DiscreteUniformSampler(UniformRandomProvider rng, int lower, int upper) {
        super(rng);
        if (lower > upper) {
            throw new IllegalArgumentException(lower + " > " + upper);
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public int sample() {
        int max = this.upper - this.lower + 1;
        if (max <= 0) {
            int r;
            while ((r = this.nextInt()) < this.lower || r > this.upper) {
            }
            return r;
        }
        return this.lower + this.nextInt(max);
    }

    @Override
    public String toString() {
        return "Uniform deviate [" + super.toString() + "]";
    }
}

