/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.BoxMullerGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class BoxMullerLogNormalSampler
extends SamplerBase
implements ContinuousSampler {
    private final double scale;
    private final double shape;
    private final BoxMullerGaussianSampler gaussian;

    public BoxMullerLogNormalSampler(UniformRandomProvider rng, double scale, double shape) {
        super(null);
        this.scale = scale;
        this.shape = shape;
        this.gaussian = new BoxMullerGaussianSampler(rng, 0.0, 1.0);
    }

    @Override
    public double sample() {
        return Math.exp(this.scale + this.shape * this.gaussian.sample());
    }

    @Override
    public String toString() {
        return "Box-Muller Log Normal [" + this.gaussian.toString() + "]";
    }
}

