/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.rng.UniformRandomProvider;

public class CollectionSampler<T> {
    private final List<T> items;
    private final UniformRandomProvider rng;

    public CollectionSampler(UniformRandomProvider rng, Collection<T> collection) {
        if (collection.size() <= 0) {
            throw new IllegalArgumentException("Empty collection");
        }
        this.rng = rng;
        this.items = new ArrayList<T>(collection);
    }

    public T sample() {
        return this.items.get(this.rng.nextInt(this.items.size()));
    }
}

