/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.rng.examples.stress.ApplicationException;
import org.apache.commons.rng.examples.stress.LogUtils;

final class ProcessUtils {
    private static final long DEFAULT_TIMEOUT_MILLIS = 1000L;

    private ProcessUtils() {
    }

    static void checkExecutable(File executable) {
        if (!executable.exists() || !executable.canExecute()) {
            throw new ApplicationException("Program is not executable: " + executable);
        }
    }

    static void checkOutputDirectory(File fileOutputPrefix) {
        File reportDir = fileOutputPrefix.getAbsoluteFile().getParentFile();
        if (!(reportDir.exists() && reportDir.isDirectory() && reportDir.canWrite())) {
            throw new ApplicationException("Invalid output directory: " + reportDir);
        }
    }

    static List<String> buildSubProcessCommand(File executable, List<String> executableArguments) {
        ArrayList<String> command = new ArrayList<String>();
        try {
            command.add(executable.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new ApplicationException("Cannot resolve executable path: " + ex.getMessage(), ex);
        }
        command.addAll(executableArguments);
        return command;
    }

    static Integer getExitValue(Process process) {
        return ProcessUtils.getExitValue(process, 1000L);
    }

    static Integer getExitValue(Process process, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        long remaining = timeoutMillis;
        while (remaining > 0L) {
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                try {
                    Thread.sleep(Math.min(remaining + 1L, 100L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                remaining = timeoutMillis - (System.currentTimeMillis() - startTime);
            }
        }
        LogUtils.error("Failed to obtain exit value after %d ms, forcing termination", timeoutMillis);
        process.destroy();
        return null;
    }
}

