/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.commons.rng.examples.stress.ApplicationException;
import org.apache.commons.rng.examples.stress.LogUtils;
import org.apache.commons.rng.examples.stress.RNGUtils;
import org.apache.commons.rng.examples.stress.StandardOptions;
import org.apache.commons.rng.examples.stress.StressTestData;
import org.apache.commons.rng.examples.stress.StressTestDataList;
import org.apache.commons.rng.simple.RandomSource;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List random generators."})
class ListCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private StandardOptions reusableOptions;
    @CommandLine.Option(names={"-f", "--format"}, description={"The list format (default: ${DEFAULT-VALUE}).", "Valid values: ${COMPLETION-CANDIDATES}."}, paramLabel="<format>")
    private ListFormat listFormat = ListFormat.STRESS_TEST;
    @CommandLine.Option(names={"--provider"}, description={"The provider type (default: ${DEFAULT-VALUE}).", "Valid values: ${COMPLETION-CANDIDATES}."}, paramLabel="<provider>")
    private ProviderType providerType = ProviderType.ALL;
    @CommandLine.Option(names={"-p", "--prefix"}, description={"The ID prefix.", "Used for the stress test format."})
    private String idPrefix = "";
    @CommandLine.Option(names={"-t", "--trials"}, description={"The number of trials for each random generator.", "Used for the stress test format."})
    private int trials = 1;

    ListCommand() {
    }

    @Override
    public Void call() throws Exception {
        LogUtils.setLogLevel(this.reusableOptions.logLevel);
        StressTestDataList list = new StressTestDataList(this.idPrefix, this.trials);
        if (this.providerType == ProviderType.INT) {
            list = list.subsetIntSource();
        } else if (this.providerType == ProviderType.LONG) {
            list = list.subsetLongSource();
        }
        StringBuilder sb = new StringBuilder();
        switch (this.listFormat) {
            case PLAIN: {
                ListCommand.writePlainData(sb, list);
                break;
            }
            default: {
                ListCommand.writeStressTestData(sb, list);
            }
        }
        System.out.append(sb);
        return null;
    }

    static void writePlainData(Appendable appendable, Iterable<StressTestData> testData) throws IOException {
        String newLine = System.lineSeparator();
        for (StressTestData data : testData) {
            appendable.append(data.getRandomSource().name());
            if (data.getArgs() != null) {
                appendable.append(' ');
                appendable.append(Arrays.toString(data.getArgs()));
            }
            appendable.append(newLine);
        }
    }

    static void writeStressTestData(Appendable appendable, Iterable<StressTestData> testData) throws IOException {
        int idWidth = 0;
        int randomSourceWidth = 15;
        for (StressTestData data : testData) {
            idWidth = Math.max(idWidth, data.getId().length());
            randomSourceWidth = Math.max(randomSourceWidth, data.getRandomSource().name().length());
        }
        String newLine = System.lineSeparator();
        appendable.append("# Random generators list.").append(newLine);
        appendable.append("# Any generator with no trials is ignored during testing.").append(newLine);
        appendable.append("#").append(newLine);
        String format = String.format("# %%-%ds   %%-%ds   trials   [constructor arguments ...]%%n", idWidth, randomSourceWidth);
        Formatter formatter = new Formatter(appendable);
        formatter.format(format, "ID", "RandomSource");
        format = String.format("%%-%ds   %%-%ds   ", idWidth + 2, randomSourceWidth);
        for (StressTestData data : testData) {
            formatter.format(format, data.getId(), data.getRandomSource().name());
            if (data.getArgs() == null) {
                appendable.append(Integer.toString(data.getTrials()));
            } else {
                formatter.format("%-6d   %s", data.getTrials(), Arrays.toString(data.getArgs()));
            }
            appendable.append(newLine);
        }
        formatter.flush();
    }

    static Iterable<StressTestData> readStressTestData(Readable readable) throws IOException {
        ArrayList<StressTestData> list = new ArrayList<StressTestData>();
        HashSet<String> ids = new HashSet<String>();
        Scanner scanner = new Scanner(readable);
        try {
            while (scanner.hasNextLine()) {
                String id = scanner.next();
                if (id.isEmpty() || id.charAt(0) == '#') {
                    scanner.nextLine();
                    continue;
                }
                if (!ids.add(id)) {
                    throw new ApplicationException("Non-unique ID in strest test data: " + id);
                }
                RandomSource randomSource = RandomSource.valueOf((String)scanner.next());
                int trials = scanner.nextInt();
                String arguments = scanner.nextLine().trim();
                Object[] args = ListCommand.parseArguments(randomSource, arguments);
                list.add(new StressTestData(id, randomSource, args, trials));
            }
        }
        catch (IllegalArgumentException | NoSuchElementException ex) {
            if (scanner.ioException() != null) {
                throw scanner.ioException();
            }
            throw new ApplicationException("Failed to read stress test data", ex);
        }
        return list;
    }

    static Object[] parseArguments(RandomSource randomSource, String arguments) {
        if (arguments.isEmpty()) {
            return null;
        }
        int len = arguments.length();
        if (len < 2 || arguments.charAt(0) != '[' || arguments.charAt(len - 1) != ']') {
            throw new ApplicationException("RandomSource arguments should be an [array]: " + arguments);
        }
        String[] tokens = arguments.substring(1, len - 1).split(", *");
        ArrayList<Object> args = new ArrayList<Object>();
        for (String token : tokens) {
            args.add(RNGUtils.parseArgument(token));
        }
        return args.toArray();
    }

    static enum ProviderType {
        ALL,
        INT,
        LONG;

    }

    static enum ListFormat {
        STRESS_TEST,
        PLAIN;

    }
}

