/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.sampling;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.BoxMullerNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ChengBetaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.rng.sampling.distribution.GaussianSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformParetoSampler;
import org.apache.commons.rng.sampling.distribution.LogNormalSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.rng.simple.RandomSource;

public class ProbabilityDensityApproximation {
    private final int numBins;
    private final long numSamples;

    private ProbabilityDensityApproximation(int numBins, long numSamples) {
        this.numBins = numBins;
        this.numSamples = numSamples;
    }

    private void createDensity(ContinuousSampler sampler, double min, double max, String outputFile) throws IOException {
        double binSize = (max - min) / (double)this.numBins;
        long[] histogram = new long[this.numBins];
        long n = 0L;
        long belowMin = 0L;
        long aboveMax = 0L;
        while (++n < this.numSamples) {
            int binIndex;
            double r = sampler.sample();
            if (r < min) {
                ++belowMin;
                continue;
            }
            if (r >= max) {
                ++aboveMax;
                continue;
            }
            int n2 = binIndex = (int)((r - min) / binSize);
            histogram[n2] = histogram[n2] + 1L;
        }
        double binHalfSize = 0.5 * binSize;
        double norm = 1.0 / (binSize * (double)this.numSamples);
        PrintWriter out = new PrintWriter(outputFile);
        out.println("# Sampler: " + sampler);
        out.println("# Number of bins: " + this.numBins);
        out.println("# Min: " + min + " (fraction of samples below: " + (double)belowMin / (double)this.numSamples + ")");
        out.println("# Max: " + max + " (fraction of samples above: " + (double)aboveMax / (double)this.numSamples + ")");
        out.println("# Bin width: " + binSize);
        out.println("# Histogram normalization factor: " + norm);
        out.println("#");
        out.println("# " + (min - binHalfSize) + " " + (double)belowMin * norm);
        for (int i = 0; i < this.numBins; ++i) {
            out.println(min + (double)(i + 1) * binSize - binHalfSize + " " + (double)histogram[i] * norm);
        }
        out.println("# " + (max + binHalfSize) + " " + (double)aboveMax * norm);
        out.close();
    }

    public static void main(String[] args) throws IOException {
        int numBins = Integer.valueOf(args[0]);
        long numSamples = Long.valueOf(args[1]);
        ProbabilityDensityApproximation app = new ProbabilityDensityApproximation(numBins, numSamples);
        RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.XOR_SHIFT_1024_S);
        double gaussMean = 1.0;
        double gaussSigma = 2.0;
        double gaussMin = -9.0;
        double gaussMax = 11.0;
        app.createDensity((ContinuousSampler)new GaussianSampler((NormalizedGaussianSampler)new ZigguratNormalizedGaussianSampler((UniformRandomProvider)rng), 1.0, 2.0), -9.0, 11.0, "gauss.ziggurat.txt");
        app.createDensity((ContinuousSampler)new GaussianSampler((NormalizedGaussianSampler)new MarsagliaNormalizedGaussianSampler((UniformRandomProvider)rng), 1.0, 2.0), -9.0, 11.0, "gauss.marsaglia.txt");
        app.createDensity((ContinuousSampler)new GaussianSampler((NormalizedGaussianSampler)new BoxMullerNormalizedGaussianSampler((UniformRandomProvider)rng), 1.0, 2.0), -9.0, 11.0, "gauss.boxmuller.txt");
        double alphaBeta = 4.3;
        double betaBeta = 2.1;
        double betaMin = 0.0;
        double betaMax = 1.0;
        app.createDensity((ContinuousSampler)new ChengBetaSampler((UniformRandomProvider)rng, 4.3, 2.1), 0.0, 1.0, "beta.case1.txt");
        double alphaBetaAlt = 0.5678;
        double betaBetaAlt = 0.1234;
        app.createDensity((ContinuousSampler)new ChengBetaSampler((UniformRandomProvider)rng, 0.5678, 0.1234), 0.0, 1.0, "beta.case2.txt");
        double meanExp = 3.45;
        double expMin = 0.0;
        double expMax = 60.0;
        app.createDensity((ContinuousSampler)new AhrensDieterExponentialSampler((UniformRandomProvider)rng, 3.45), 0.0, 60.0, "exp.txt");
        double thetaGammaSmallerThanOne = 0.1234;
        double alphaGamma = 3.456;
        double gammaMin = 0.0;
        double gammaMax1 = 40.0;
        app.createDensity((ContinuousSampler)new AhrensDieterMarsagliaTsangGammaSampler((UniformRandomProvider)rng, 3.456, 0.1234), 0.0, 40.0, "gamma.case1.txt");
        double thetaGammaLargerThanOne = 2.345;
        double gammaMax2 = 70.0;
        app.createDensity((ContinuousSampler)new AhrensDieterMarsagliaTsangGammaSampler((UniformRandomProvider)rng, 3.456, 2.345), 0.0, 70.0, "gamma.case2.txt");
        double scalePareto = 23.45;
        double shapePareto = 0.789;
        double paretoMin = 23.0;
        double paretoMax = 400.0;
        app.createDensity((ContinuousSampler)new InverseTransformParetoSampler((UniformRandomProvider)rng, 23.45, 0.789), 23.0, 400.0, "pareto.txt");
        double loUniform = -9.876;
        double hiUniform = 5.432;
        app.createDensity((ContinuousSampler)new ContinuousUniformSampler((UniformRandomProvider)rng, -9.876, 5.432), -9.876, 5.432, "uniform.txt");
        double scaleLogNormal = 2.345;
        double shapeLogNormal = 0.1234;
        double logNormalMin = 5.0;
        double logNormalMax = 25.0;
        app.createDensity((ContinuousSampler)new LogNormalSampler((NormalizedGaussianSampler)new ZigguratNormalizedGaussianSampler((UniformRandomProvider)rng), 2.345, 0.1234), 5.0, 25.0, "lognormal.ziggurat.txt");
        app.createDensity((ContinuousSampler)new LogNormalSampler((NormalizedGaussianSampler)new MarsagliaNormalizedGaussianSampler((UniformRandomProvider)rng), 2.345, 0.1234), 5.0, 25.0, "lognormal.marsaglia.txt");
        app.createDensity((ContinuousSampler)new LogNormalSampler((NormalizedGaussianSampler)new BoxMullerNormalizedGaussianSampler((UniformRandomProvider)rng), 2.345, 0.1234), 5.0, 25.0, "lognormal.boxmuller.txt");
    }
}

