/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jpms.app;

import java.lang.module.ModuleDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.examples.jpms.lib.DiceGame;
import org.apache.commons.rng.simple.RandomSource;

public final class DiceGameApplication {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final DiceGame game;

    private DiceGameApplication(int numPlayers, int numRounds, RandomSource identifier) {
        this.game = new DiceGame(numPlayers, numRounds, (UniformRandomProvider)RandomSource.create((RandomSource)identifier), 4.3, 2.1);
    }

    public static void main(String[] args) {
        int numGames = Integer.parseInt(args[0]);
        DiceGameApplication app = new DiceGameApplication(Integer.parseInt(args[1]), Integer.parseInt(args[2]), RandomSource.valueOf((String)args[3]));
        app.displayModuleInfo();
        for (int i = 1; i <= numGames; ++i) {
            System.out.println("--- Game " + i + " ---");
            System.out.println(DiceGameApplication.display(app.game.play()));
        }
    }

    private static String display(int[] scores) {
        int[][] a = new int[scores.length][2];
        for (int i = 0; i < scores.length; ++i) {
            a[i][0] = i;
            a[i][1] = scores[i];
        }
        Arrays.sort(a, Comparator.comparingInt(x -> -x[1]));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < scores.length; ++i) {
            result.append("Player ").append(a[i][0] + 1).append(" has ").append(a[i][1]).append(" points").append(LINE_SEP);
        }
        return result.toString();
    }

    private void displayModuleInfo() {
        StringBuilder str = new StringBuilder();
        for (Module mod : new Module[]{DiceGame.class.getModule(), DiceGameApplication.class.getModule()}) {
            System.out.println("--- " + mod + " ---");
            ModuleDescriptor desc = mod.getDescriptor();
            for (ModuleDescriptor.Requires r : desc.requires()) {
                System.out.println(mod.getName() + " requires " + r.name());
            }
            System.out.println();
        }
    }
}

