/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.simple;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.simple.RandomSource;
import org.apache.commons.rng.simple.internal.SeedFactory;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class SeedGenerationPerformance {
    static final long SEED_INCREMENT = -4942790177534073029L;
    private static final ReentrantLock UNFAIR_LOCK = new ReentrantLock(false);
    private static final ReentrantLock FAIR_LOCK = new ReentrantLock(true);
    private static final long GOLDEN_GAMMA = -7046029254386353131L;
    private int intValue;
    private long longValue;
    private volatile int volatileIntValue;
    private volatile long volatileLongValue;
    private final AtomicInteger atomicInt = new AtomicInteger();
    private final AtomicLong atomicLong = new AtomicLong();
    private final AtomicLong state = new AtomicLong();
    private final UniformRandomProvider xoRoShiRo128Plus = RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PLUS);
    private final UniformRandomProvider xorShift1024StarPhi = RandomSource.create((RandomSource)RandomSource.XOR_SHIFT_1024_S_PHI);
    private final UniformRandomProvider well44497b = RandomSource.create((RandomSource)RandomSource.WELL_44497_B);
    private final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextInt(UniformRandomProvider rng) {
        UniformRandomProvider uniformRandomProvider = rng;
        synchronized (uniformRandomProvider) {
            return rng.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextLong(UniformRandomProvider rng) {
        UniformRandomProvider uniformRandomProvider = rng;
        synchronized (uniformRandomProvider) {
            return rng.nextLong();
        }
    }

    private static int nextInt(Lock lock, UniformRandomProvider rng) {
        lock.lock();
        try {
            int n = rng.nextInt();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextLong(Lock lock, UniformRandomProvider rng) {
        lock.lock();
        try {
            long l = rng.nextLong();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    private static long mixLong(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int mixInt(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    @Benchmark
    public void baselineVoid() {
    }

    @Benchmark
    public int baselineInt() {
        return this.intValue;
    }

    @Benchmark
    public long baselineLong() {
        return this.longValue;
    }

    @Benchmark
    public int XoRoShiRo128Plus_nextInt() {
        return this.xoRoShiRo128Plus.nextInt();
    }

    @Benchmark
    public int XorShift1024StarPhi_nextInt() {
        return this.xorShift1024StarPhi.nextInt();
    }

    @Benchmark
    public int Well44497b_nextInt() {
        return this.well44497b.nextInt();
    }

    @Benchmark
    public long XoRoShiRo128Plus_nextLong() {
        return this.xoRoShiRo128Plus.nextLong();
    }

    @Benchmark
    public long XorShift1024StarPhi_nextLong() {
        return this.xorShift1024StarPhi.nextLong();
    }

    @Benchmark
    public long Well44497b_nextLong() {
        return this.well44497b.nextLong();
    }

    @Benchmark
    public int Threads1_SeedFactory_createInt() {
        return SeedFactory.createInt();
    }

    @Benchmark
    public long Threads1_SeedFactory_createLong() {
        return SeedFactory.createLong();
    }

    @Benchmark
    public long Threads1_System_currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Benchmark
    public long Threads1_System_nanoTime() {
        return System.nanoTime();
    }

    @Benchmark
    public int Threads1_System_identityHashCode() {
        return System.identityHashCode(new Object());
    }

    @Benchmark
    public long Threads1_ThreadLocalRandom_nextLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    @Benchmark
    public int Threads1_ThreadLocalRandom_nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    @Benchmark
    public long Threads1_ThreadLocalRNG_nextLong() {
        return ThreadLocalRNG.current().nextLong();
    }

    @Benchmark
    public int Threads1_ThreadLocalRNG_nextInt() {
        return ThreadLocalRNG.current().nextInt();
    }

    @Benchmark
    public long Threads1_ThreadLocalSplitMix_nextLong() {
        return ThreadLocalSplitMix.current().nextLong();
    }

    @Benchmark
    public int Threads1_ThreadLocalSplitMix_nextInt() {
        return ThreadLocalSplitMix.current().nextInt();
    }

    @Benchmark
    public long Threads1_ThreadLocalSequenceMix_nextLong() {
        return SeedGenerationPerformance.mixLong(ThreadLocalSequence.next());
    }

    @Benchmark
    public int Threads1_ThreadLocalSequenceMix_nextInt() {
        return SeedGenerationPerformance.mixInt(ThreadLocalSequence.next());
    }

    @Benchmark
    public long Threads1_Random_nextLong() {
        return this.random.nextLong();
    }

    @Benchmark
    public int Threads1_Random_nextInt() {
        return this.random.nextInt();
    }

    @Benchmark
    public long Threads1_SyncSplitMix_nextLong() {
        return SeedGenerationPerformance.mixLong(this.state.getAndAdd(-7046029254386353131L));
    }

    @Benchmark
    public int Threads1_SyncSplitMix_nextInt() {
        return SeedGenerationPerformance.mixInt(this.state.getAndAdd(-7046029254386353131L));
    }

    @Benchmark
    public int Threads1_Sync_XoRoShiRo128Plus_nextInt() {
        return SeedGenerationPerformance.nextInt(this.xoRoShiRo128Plus);
    }

    @Benchmark
    public int Threads1_Sync_XorShift1024StarPhi_nextInt() {
        return SeedGenerationPerformance.nextInt(this.xorShift1024StarPhi);
    }

    @Benchmark
    public int Threads1_Sync_Well44497b_nextInt() {
        return SeedGenerationPerformance.nextInt(this.well44497b);
    }

    @Benchmark
    public long Threads1_Sync_XoRoShiRo128Plus_nextLong() {
        return SeedGenerationPerformance.nextLong(this.xoRoShiRo128Plus);
    }

    @Benchmark
    public long Threads1_Sync_XorShift1024StarPhi_nextLong() {
        return SeedGenerationPerformance.nextLong(this.xorShift1024StarPhi);
    }

    @Benchmark
    public long Threads1_Sync_Well44497b_nextLong() {
        return SeedGenerationPerformance.nextLong(this.well44497b);
    }

    @Benchmark
    public int Threads1_UnfairLock_XoRoShiRo128Plus_nextInt() {
        return SeedGenerationPerformance.nextInt(UNFAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    public int Threads1_UnfairLock_XorShift1024StarPhi_nextInt() {
        return SeedGenerationPerformance.nextInt(UNFAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    public int Threads1_UnfairLock_Well44497b_nextInt() {
        return SeedGenerationPerformance.nextInt(UNFAIR_LOCK, this.well44497b);
    }

    @Benchmark
    public long Threads1_UnfairLock_XoRoShiRo128Plus_nextLong() {
        return SeedGenerationPerformance.nextLong(UNFAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    public long Threads1_UnfairLock_XorShift1024StarPhi_nextLong() {
        return SeedGenerationPerformance.nextLong(UNFAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    public long Threads1_UnfairLock_Well44497b_nextLong() {
        return SeedGenerationPerformance.nextLong(UNFAIR_LOCK, this.well44497b);
    }

    @Benchmark
    public int Threads1_FairLock_XoRoShiRo128Plus_nextInt() {
        return SeedGenerationPerformance.nextInt(FAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    public int Threads1_FairLock_XorShift1024StarPhi_nextInt() {
        return SeedGenerationPerformance.nextInt(FAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    public int Threads1_FairLock_Well44497b_nextInt() {
        return SeedGenerationPerformance.nextInt(FAIR_LOCK, this.well44497b);
    }

    @Benchmark
    public long Threads1_FairLock_XoRoShiRo128Plus_nextLong() {
        return SeedGenerationPerformance.nextLong(FAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    public long Threads1_FairLock_XorShift1024StarPhi_nextLong() {
        return SeedGenerationPerformance.nextLong(FAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    public long Threads1_FairLock_Well44497b_nextLong() {
        return SeedGenerationPerformance.nextLong(FAIR_LOCK, this.well44497b);
    }

    @Benchmark
    public int Threads1_volatileInt_increment() {
        return ++this.volatileIntValue;
    }

    @Benchmark
    public long Threads1_volatileLong_increment() {
        return ++this.volatileLongValue;
    }

    @Benchmark
    public int Threads1_AtomicInt_getAndIncrement() {
        return this.atomicInt.getAndIncrement();
    }

    @Benchmark
    public long Threads1_AtomicLong_getAndIncrement() {
        return this.atomicLong.getAndIncrement();
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_SeedFactory_createInt() {
        return SeedFactory.createInt();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_SeedFactory_createLong() {
        return SeedFactory.createLong();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_System_currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_System_nanoTime() {
        return System.nanoTime();
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_System_identityHashCode() {
        return System.identityHashCode(new Object());
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_ThreadLocalRandom_nextLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_ThreadLocalRandom_nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_ThreadLocalRNG_nextLong() {
        return ThreadLocalRNG.current().nextLong();
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_ThreadLocalRNG_nextInt() {
        return ThreadLocalRNG.current().nextInt();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_ThreadLocalSplitMix_nextLong() {
        return ThreadLocalSplitMix.current().nextLong();
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_ThreadLocalSplitMix_nextInt() {
        return ThreadLocalSplitMix.current().nextInt();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_ThreadLocalSequenceMix_nextLong() {
        return SeedGenerationPerformance.mixLong(ThreadLocalSequence.next());
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_ThreadLocalSequenceMix_nextInt() {
        return SeedGenerationPerformance.mixInt(ThreadLocalSequence.next());
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_Random_nextLong() {
        return this.random.nextLong();
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_Random_nextInt() {
        return this.random.nextInt();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_SyncSplitMix_nextLong() {
        return SeedGenerationPerformance.mixLong(this.state.getAndAdd(-7046029254386353131L));
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_SyncSplitMix_nextInt() {
        return SeedGenerationPerformance.mixInt(this.state.getAndAdd(-7046029254386353131L));
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_Sync_XoRoShiRo128Plus_nextInt() {
        return SeedGenerationPerformance.nextInt(this.xoRoShiRo128Plus);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_Sync_XorShift1024StarPhi_nextInt() {
        return SeedGenerationPerformance.nextInt(this.xorShift1024StarPhi);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_Sync_Well44497b_nextInt() {
        return SeedGenerationPerformance.nextInt(this.well44497b);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_Sync_XoRoShiRo128Plus_nextLong() {
        return SeedGenerationPerformance.nextLong(this.xoRoShiRo128Plus);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_Sync_XorShift1024StarPhi_nextLong() {
        return SeedGenerationPerformance.nextLong(this.xorShift1024StarPhi);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_Sync_Well44497b_nextLong() {
        return SeedGenerationPerformance.nextLong(this.well44497b);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_UnfairLock_XoRoShiRo128Plus_nextInt() {
        return SeedGenerationPerformance.nextInt(UNFAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_UnfairLock_XorShift1024StarPhi_nextInt() {
        return SeedGenerationPerformance.nextInt(UNFAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_UnfairLock_Well44497b_nextInt() {
        return SeedGenerationPerformance.nextInt(UNFAIR_LOCK, this.well44497b);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_UnfairLock_XoRoShiRo128Plus_nextLong() {
        return SeedGenerationPerformance.nextLong(UNFAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_UnfairLock_XorShift1024StarPhi_nextLong() {
        return SeedGenerationPerformance.nextLong(UNFAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_UnfairLock_Well44497b_nextLong() {
        return SeedGenerationPerformance.nextLong(UNFAIR_LOCK, this.well44497b);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_FairLock_XoRoShiRo128Plus_nextInt() {
        return SeedGenerationPerformance.nextInt(FAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_FairLock_XorShift1024StarPhi_nextInt() {
        return SeedGenerationPerformance.nextInt(FAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_FairLock_Well44497b_nextInt() {
        return SeedGenerationPerformance.nextInt(FAIR_LOCK, this.well44497b);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_FairLock_XoRoShiRo128Plus_nextLong() {
        return SeedGenerationPerformance.nextLong(FAIR_LOCK, this.xoRoShiRo128Plus);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_FairLock_XorShift1024StarPhi_nextLong() {
        return SeedGenerationPerformance.nextLong(FAIR_LOCK, this.xorShift1024StarPhi);
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_FairLock_Well44497b_nextLong() {
        return SeedGenerationPerformance.nextLong(FAIR_LOCK, this.well44497b);
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_volatileInt_increment() {
        return ++this.volatileIntValue;
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_volatileLong_increment() {
        return ++this.volatileLongValue;
    }

    @Benchmark
    @Threads(value=4)
    public int Threads4_AtomicInt_getAndIncrement() {
        return this.atomicInt.getAndIncrement();
    }

    @Benchmark
    @Threads(value=4)
    public long Threads4_AtomicLong_getAndIncrement() {
        return this.atomicLong.getAndIncrement();
    }

    private static final class ThreadLocalSequence
    extends ThreadLocal<long[]> {
        private static final AtomicLong SEED = new AtomicLong(0L);
        private static final ThreadLocalSequence INSTANCE = new ThreadLocalSequence();

        private ThreadLocalSequence() {
        }

        @Override
        protected long[] initialValue() {
            return new long[]{SEED.getAndAdd(-4942790177534073029L)};
        }

        public static long next() {
            long[] value = (long[])INSTANCE.get();
            value[0] = value[0] + -7046029254386353131L;
            return value[0];
        }
    }

    private static final class ThreadLocalSplitMix
    extends ThreadLocal<SplitMix64> {
        private static final AtomicLong SEED = new AtomicLong(0L);
        private static final ThreadLocalSplitMix INSTANCE = new ThreadLocalSplitMix();

        private ThreadLocalSplitMix() {
        }

        @Override
        protected SplitMix64 initialValue() {
            return new SplitMix64(SEED.getAndAdd(-4942790177534073029L));
        }

        public static SplitMix64 current() {
            return (SplitMix64)INSTANCE.get();
        }
    }

    private static final class ThreadLocalRNG
    extends ThreadLocal<UniformRandomProvider> {
        private static final AtomicLong SEED = new AtomicLong(0L);
        private static final ThreadLocalRNG INSTANCE = new ThreadLocalRNG();

        private ThreadLocalRNG() {
        }

        @Override
        protected UniformRandomProvider initialValue() {
            return new SplitMix64(SEED.getAndAdd(-4942790177534073029L));
        }

        public static UniformRandomProvider current() {
            return (UniformRandomProvider)INSTANCE.get();
        }
    }
}

