/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.sampling.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.KempSmallMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.LargeMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class PoissonSamplersPerformance {
    private int value;

    @Benchmark
    public int baselineInt() {
        return this.value;
    }

    @Benchmark
    public double baselineExp(Means mean) {
        return Math.exp(-mean.getMean());
    }

    @Benchmark
    public int sample(Sources sources) {
        return sources.getSampler().sample();
    }

    @Benchmark
    public int singleSample(Sources sources) {
        return sources.createSampler().sample();
    }

    static class TinyMeanPoissonSampler
    implements DiscreteSampler {
        private final long p0;
        private final UniformRandomProvider rng;

        TinyMeanPoissonSampler(UniformRandomProvider rng, double mean) {
            this.rng = rng;
            if (mean <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.p0 = (long)(Math.exp(-mean) * 4.294967296E9);
            if (this.p0 == 0L) {
                throw new IllegalArgumentException("No p(x=0) probability for mean: " + mean);
            }
        }

        public int sample() {
            int n = 0;
            long r = this.nextUnsigned32();
            while (r >= this.p0) {
                r = r * this.nextUnsigned32() >>> 32;
                ++n;
            }
            return n >= 0 ? n : Integer.MAX_VALUE;
        }

        private long nextUnsigned32() {
            return (long)this.rng.nextInt() & 0xFFFFFFFFL;
        }
    }

    static class KempSmallMeanPoissonSamplerGuideTable
    implements DiscreteSampler {
        private static final int[] TABLE_SIZE = new int[]{8, 10, 12, 14, 16, 18, 20, 22, 24, 25, 27, 29, 30, 32, 33, 35, 36, 38, 39, 41};
        private final UniformRandomProvider rng;
        private final double mean;
        private final double[] cumulativeProbability;
        private int tabulatedX;
        private double probabilityX;
        private final int[] guideTable;

        KempSmallMeanPoissonSamplerGuideTable(UniformRandomProvider rng, double mean) {
            if (mean <= 0.0) {
                throw new IllegalArgumentException("mean is not strictly positive: " + mean);
            }
            this.probabilityX = Math.exp(-mean);
            if (!(this.probabilityX > 0.0)) {
                throw new IllegalArgumentException("No probability for mean " + mean);
            }
            this.rng = rng;
            this.mean = mean;
            int upperMean = (int)Math.ceil(mean);
            int size = upperMean < TABLE_SIZE.length ? TABLE_SIZE[upperMean] : upperMean * 2;
            this.cumulativeProbability = new double[size];
            this.cumulativeProbability[0] = this.probabilityX;
            this.guideTable = new int[this.cumulativeProbability.length + 1];
            this.initialiseGuideTable(this.probabilityX);
        }

        private void initialiseGuideTable(double p0) {
            for (int index = this.getGuideTableIndex(p0); index >= 0; --index) {
                this.guideTable[index] = 1;
            }
        }

        private void updateGuideTable(double p, int x) {
            int x1 = x + 1;
            int index = this.getGuideTableIndex(p);
            do {
                this.guideTable[index--] = x1;
            } while (index > 0 && this.guideTable[index] == 0);
        }

        private int getGuideTableIndex(double p) {
            return (int)(p * (double)(this.guideTable.length - 1));
        }

        public int sample() {
            double u = this.rng.nextDouble();
            if (u <= this.cumulativeProbability[this.tabulatedX]) {
                int sample = this.guideTable[this.getGuideTableIndex(u)] - 1;
                if (u > this.cumulativeProbability[sample]) {
                    return sample + 1;
                }
                while (sample != 0 && u <= this.cumulativeProbability[sample - 1]) {
                    --sample;
                }
                return sample;
            }
            int x1 = this.tabulatedX + 1;
            while (x1 < this.cumulativeProbability.length) {
                this.probabilityX = this.nextProbability(this.probabilityX, x1);
                double sum = this.cumulativeProbability[this.tabulatedX] + this.probabilityX;
                this.cumulativeProbability[++this.tabulatedX] = sum;
                this.updateGuideTable(sum, this.tabulatedX);
                if (u <= sum) {
                    return this.tabulatedX;
                }
                x1 = this.tabulatedX + 1;
            }
            return this.sampleWithinLongTail(u - this.cumulativeProbability[this.tabulatedX], x1, this.nextProbability(this.probabilityX, x1));
        }

        private double nextProbability(double px, int x1) {
            return px * this.mean / (double)x1;
        }

        private int sampleWithinLongTail(double u, int x, double p) {
            while (u > p) {
                u -= p;
                if ((p = this.nextProbability(p, ++x)) != 0.0) continue;
                break;
            }
            return x;
        }
    }

    static class KempSmallMeanPoissonSamplerBinarySearch
    implements DiscreteSampler {
        private static final int[] TABLE_SIZE = new int[]{8, 10, 12, 14, 16, 18, 20, 22, 24, 25, 27, 29, 30, 32, 33, 35, 36, 38, 39, 41};
        private final UniformRandomProvider rng;
        private final double mean;
        private final double[] fx;
        private int lastX;
        private double px;

        KempSmallMeanPoissonSamplerBinarySearch(UniformRandomProvider rng, double mean) {
            if (mean <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.px = Math.exp(-mean);
            if (!(this.px > 0.0)) {
                throw new IllegalArgumentException();
            }
            this.rng = rng;
            this.mean = mean;
            int upperMean = (int)Math.ceil(mean);
            this.fx = new double[upperMean < TABLE_SIZE.length ? TABLE_SIZE[upperMean] : upperMean * 2];
            this.fx[0] = this.px;
        }

        public int sample() {
            double u = this.rng.nextDouble();
            if (u <= this.fx[this.lastX]) {
                int lower = 0;
                int upper = this.lastX;
                while (lower < upper) {
                    int mid = 3 * lower + upper >>> 2;
                    double midVal = this.fx[mid];
                    if (u > midVal) {
                        lower = mid + 1;
                        continue;
                    }
                    upper = mid;
                }
                return upper;
            }
            int x1 = this.lastX + 1;
            while (x1 < this.fx.length) {
                this.px = this.nextProbability(this.px, x1);
                double sum = this.fx[this.lastX] + this.px;
                this.fx[++this.lastX] = sum;
                if (u <= sum) {
                    return this.lastX;
                }
                x1 = this.lastX + 1;
            }
            return this.sampleWithinLongTail(u - this.fx[this.lastX], x1, this.nextProbability(this.px, x1));
        }

        private double nextProbability(double p, int x1) {
            return p * this.mean / (double)x1;
        }

        private int sampleWithinLongTail(double u, int x, double p) {
            while (u > p) {
                u -= p;
                if ((p = this.nextProbability(p, ++x)) != 0.0) continue;
                return x;
            }
            return x;
        }
    }

    static class KempSmallMeanPoissonSamplerP50
    implements DiscreteSampler {
        private static final double ONE_HALF = 0.5;
        private static final double LONG_TAIL_THRESHOLD = 0.999;
        private final UniformRandomProvider rng;
        private final double p0;
        private final double mean;
        private final double fx;
        private final int x1;
        private final double px1;

        KempSmallMeanPoissonSamplerP50(UniformRandomProvider rng, double mean) {
            if (mean <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.rng = rng;
            this.p0 = Math.exp(-mean);
            this.mean = mean;
            if (this.p0 <= 0.999) {
                double sum;
                if (this.p0 == 0.0) {
                    throw new IllegalArgumentException();
                }
                double p = this.p0;
                int x = 0;
                for (sum = p; sum < 0.5; sum += (p *= mean / (double)(++x))) {
                }
                this.fx = sum;
                this.x1 = x + 1;
                this.px1 = p * mean / (double)this.x1;
            } else {
                this.fx = 0.0;
                this.x1 = 0;
                this.px1 = this.p0;
            }
        }

        public int sample() {
            double u = this.rng.nextDouble();
            if (u <= this.fx) {
                return this.sampleBeforeLongTail(u, 0, this.p0);
            }
            if (u <= 0.999) {
                return this.sampleBeforeLongTail(u - this.fx, this.x1, this.px1);
            }
            return this.sampleWithinLongTail(u - this.fx, this.x1, this.px1);
        }

        private int sampleBeforeLongTail(double u, int x, double p) {
            while (u > p) {
                u -= p;
                p *= this.mean / (double)(++x);
            }
            return x;
        }

        private int sampleWithinLongTail(double u, int x, double p) {
            while (u > p) {
                u -= p;
                if ((p *= this.mean / (double)(++x)) != 0.0) continue;
                return x;
            }
            return x;
        }
    }

    static class BoundedKempSmallMeanPoissonSampler
    implements DiscreteSampler {
        private final UniformRandomProvider rng;
        private final double p0;
        private final int limit;
        private final double mean;

        BoundedKempSmallMeanPoissonSampler(UniformRandomProvider rng, double mean) {
            if (mean <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.p0 = Math.exp(-mean);
            if (this.p0 == 0.0) {
                throw new IllegalArgumentException();
            }
            this.limit = (int)Math.ceil(1000.0 * mean);
            this.rng = rng;
            this.mean = mean;
        }

        public int sample() {
            double u = this.rng.nextDouble();
            int x = 0;
            for (double p = this.p0; u > p; u -= p, p *= this.mean / (double)(++x)) {
                if (x != this.limit) continue;
                return x;
            }
            return x;
        }
    }

    @State(value=Scope.Benchmark)
    public static class Sources {
        @Param(value={"WELL_44497_B", "XO_RO_SHI_RO_128_PLUS"})
        private String randomSourceName;
        @Param(value={"SmallMeanPoissonSampler", "KempSmallMeanPoissonSampler", "BoundedKempSmallMeanPoissonSampler", "KempSmallMeanPoissonSamplerP50", "KempSmallMeanPoissonSamplerBinarySearch", "KempSmallMeanPoissonSamplerGuideTable", "LargeMeanPoissonSampler", "TinyMeanPoissonSampler"})
        private String samplerType;
        @Param(value={"0.25", "0.5", "1", "2", "4", "8", "16", "32", "64"})
        private double mean;
        private UniformRandomProvider generator;
        private DiscreteSamplerFactory factory;
        private DiscreteSampler sampler;

        public UniformRandomProvider getGenerator() {
            return this.generator;
        }

        public DiscreteSampler getSampler() {
            return this.sampler;
        }

        @Setup
        public void setup() {
            RandomSource randomSource = RandomSource.valueOf((String)this.randomSourceName);
            this.generator = RandomSource.create((RandomSource)randomSource);
            if ("SmallMeanPoissonSampler".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return SmallMeanPoissonSampler.of((UniformRandomProvider)Sources.this.generator, (double)Sources.this.mean);
                    }
                };
            } else if ("KempSmallMeanPoissonSampler".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return KempSmallMeanPoissonSampler.of((UniformRandomProvider)Sources.this.generator, (double)Sources.this.mean);
                    }
                };
            } else if ("BoundedKempSmallMeanPoissonSampler".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return new BoundedKempSmallMeanPoissonSampler(Sources.this.generator, Sources.this.mean);
                    }
                };
            } else if ("KempSmallMeanPoissonSamplerP50".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return new KempSmallMeanPoissonSamplerP50(Sources.this.generator, Sources.this.mean);
                    }
                };
            } else if ("KempSmallMeanPoissonSamplerBinarySearch".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return new KempSmallMeanPoissonSamplerBinarySearch(Sources.this.generator, Sources.this.mean);
                    }
                };
            } else if ("KempSmallMeanPoissonSamplerGuideTable".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return new KempSmallMeanPoissonSamplerGuideTable(Sources.this.generator, Sources.this.mean);
                    }
                };
            } else if ("LargeMeanPoissonSampler".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return LargeMeanPoissonSampler.of((UniformRandomProvider)Sources.this.generator, (double)Sources.this.mean);
                    }
                };
            } else if ("TinyMeanPoissonSampler".equals(this.samplerType)) {
                this.factory = new DiscreteSamplerFactory(){

                    @Override
                    public DiscreteSampler create() {
                        return new TinyMeanPoissonSampler(Sources.this.generator, Sources.this.mean);
                    }
                };
            }
            this.sampler = this.factory.create();
        }

        public DiscreteSampler createSampler() {
            return this.factory.create();
        }

        static interface DiscreteSamplerFactory {
            public DiscreteSampler create();
        }
    }

    @State(value=Scope.Benchmark)
    public static class Means {
        @Param(value={"0.25", "0.5", "1", "2", "4", "8", "16", "32"})
        private double mean;

        public double getMean() {
            return this.mean;
        }
    }
}

