/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.sampling.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class DiscreteUniformSamplerGenerationPerformance {
    @Param(value={"1", "2", "4", "8", "16", "1000000"})
    private int samples;

    @Benchmark
    public void nextIntBaseline(Blackhole bh, Sources source) {
        int sum = 0;
        for (int i = 0; i < this.samples; ++i) {
            sum += source.getGenerator().nextInt();
        }
        bh.consume(sum);
    }

    @Benchmark
    public void nextIntRange(Blackhole bh, Sources source, IntRange range) {
        int n = range.getUpperBound();
        int sum = 0;
        for (int i = 0; i < this.samples; ++i) {
            sum += source.getGenerator().nextInt(n);
        }
        bh.consume(sum);
    }

    @Benchmark
    public void nextDiscreteUniformSampler(Blackhole bh, Sources source, IntRange range) {
        SharedStateDiscreteSampler sampler = DiscreteUniformSampler.of((UniformRandomProvider)source.getGenerator(), (int)0, (int)(range.getUpperBound() - 1));
        int sum = 0;
        for (int i = 0; i < this.samples; ++i) {
            sum += sampler.sample();
        }
        bh.consume(sum);
    }

    @State(value=Scope.Benchmark)
    public static class IntRange {
        @Param(value={"256", "257", "1073741825"})
        private int upperBound;

        public int getUpperBound() {
            return this.upperBound;
        }
    }

    @State(value=Scope.Benchmark)
    public static class Sources {
        @Param(value={"SPLIT_MIX_64"})
        private String randomSourceName;
        private RestorableUniformRandomProvider generator;

        public UniformRandomProvider getGenerator() {
            return this.generator;
        }

        @Setup
        public void setup() {
            RandomSource randomSource = RandomSource.valueOf((String)this.randomSourceName);
            this.generator = RandomSource.create((RandomSource)randomSource);
        }
    }
}

