/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.sampling.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.examples.jmh.RandomSources;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.BoxMullerNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ChengBetaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformParetoSampler;
import org.apache.commons.rng.sampling.distribution.LogNormalSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class ContinuousSamplersPerformance {
    private double value;

    @Benchmark
    public double baseline() {
        return this.value;
    }

    @Benchmark
    public double sample(Sources sources) {
        return sources.getSampler().sample();
    }

    @State(value=Scope.Benchmark)
    public static class Sources
    extends RandomSources {
        @Param(value={"BoxMullerNormalizedGaussianSampler", "MarsagliaNormalizedGaussianSampler", "ZigguratNormalizedGaussianSampler", "AhrensDieterExponentialSampler", "AhrensDieterGammaSampler", "MarsagliaTsangGammaSampler", "LogNormalBoxMullerNormalizedGaussianSampler", "LogNormalMarsagliaNormalizedGaussianSampler", "LogNormalZigguratNormalizedGaussianSampler", "ChengBetaSampler", "ContinuousUniformSampler", "InverseTransformParetoSampler"})
        private String samplerType;
        private ContinuousSampler sampler;

        public ContinuousSampler getSampler() {
            return this.sampler;
        }

        @Override
        @Setup
        public void setup() {
            super.setup();
            UniformRandomProvider rng = this.getGenerator();
            if ("BoxMullerNormalizedGaussianSampler".equals(this.samplerType)) {
                this.sampler = BoxMullerNormalizedGaussianSampler.of((UniformRandomProvider)rng);
            } else if ("MarsagliaNormalizedGaussianSampler".equals(this.samplerType)) {
                this.sampler = MarsagliaNormalizedGaussianSampler.of((UniformRandomProvider)rng);
            } else if ("ZigguratNormalizedGaussianSampler".equals(this.samplerType)) {
                this.sampler = ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)rng);
            } else if ("AhrensDieterExponentialSampler".equals(this.samplerType)) {
                this.sampler = AhrensDieterExponentialSampler.of((UniformRandomProvider)rng, (double)4.56);
            } else if ("AhrensDieterGammaSampler".equals(this.samplerType)) {
                this.sampler = AhrensDieterMarsagliaTsangGammaSampler.of((UniformRandomProvider)rng, (double)0.76, (double)9.8);
            } else if ("MarsagliaTsangGammaSampler".equals(this.samplerType)) {
                this.sampler = AhrensDieterMarsagliaTsangGammaSampler.of((UniformRandomProvider)rng, (double)12.34, (double)9.8);
            } else if ("LogNormalBoxMullerNormalizedGaussianSampler".equals(this.samplerType)) {
                this.sampler = LogNormalSampler.of((NormalizedGaussianSampler)BoxMullerNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)12.3, (double)4.6);
            } else if ("LogNormalMarsagliaNormalizedGaussianSampler".equals(this.samplerType)) {
                this.sampler = LogNormalSampler.of((NormalizedGaussianSampler)MarsagliaNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)12.3, (double)4.6);
            } else if ("LogNormalZigguratNormalizedGaussianSampler".equals(this.samplerType)) {
                this.sampler = LogNormalSampler.of((NormalizedGaussianSampler)ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)12.3, (double)4.6);
            } else if ("ChengBetaSampler".equals(this.samplerType)) {
                this.sampler = ChengBetaSampler.of((UniformRandomProvider)rng, (double)0.45, (double)6.7);
            } else if ("ContinuousUniformSampler".equals(this.samplerType)) {
                this.sampler = ContinuousUniformSampler.of((UniformRandomProvider)rng, (double)123.4, (double)5678.9);
            } else if ("InverseTransformParetoSampler".equals(this.samplerType)) {
                this.sampler = InverseTransformParetoSampler.of((UniformRandomProvider)rng, (double)23.45, (double)0.1234);
            }
        }
    }
}

