/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.sampling.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AliasMethodDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class AliasMethodDiscreteSamplerPerformance {
    private int value;

    @Benchmark
    public int baseline() {
        return this.value;
    }

    @Benchmark
    public int sample(DistributionData data) {
        return data.getSampler().sample();
    }

    @Benchmark
    public Object createSampler(DistributionData dist) {
        return AliasMethodDiscreteSampler.of(null, (double[])dist.getProbabilities(), (int)dist.getAlpha());
    }

    @State(value=Scope.Benchmark)
    public static class DistributionData {
        @Param(value={"7", "8", "9", "15", "16", "17", "31", "32", "33", "63", "64", "65"})
        private int size;
        @Param(value={"-1", "0", "1", "2"})
        private int alpha;
        private double[] probabilities;
        private DiscreteSampler sampler;

        public int getAlpha() {
            return this.alpha;
        }

        public double[] getProbabilities() {
            return this.probabilities;
        }

        public DiscreteSampler getSampler() {
            return this.sampler;
        }

        @Setup
        public void setup() {
            this.probabilities = DistributionData.createProbabilities(this.size);
            RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.SPLIT_MIX_64);
            this.sampler = AliasMethodDiscreteSampler.of((UniformRandomProvider)rng, (double[])this.probabilities, (int)this.alpha);
        }

        private static double[] createProbabilities(int size) {
            double[] probabilities = new double[size];
            for (int i = 0; i < size; ++i) {
                probabilities[i] = ((double)i + 1.0) / (double)size;
            }
            return probabilities;
        }
    }
}

