/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.core;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.sampling.PermutationSampler;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class RngNextIntInRangeBenchmark {
    private int intValue;

    @Benchmark
    public int baselineInt() {
        return this.intValue;
    }

    @Benchmark
    public int nextIntN(IntRange range, Source source) {
        return source.getRng().nextInt(range.getN());
    }

    @Benchmark
    @OperationsPerInvocation(value=65536)
    public int nextIntNloop65536(IntRange range, Source source) {
        int sum = 0;
        for (int i = 0; i < 65536; ++i) {
            sum += source.getRng().nextInt(range.getN());
        }
        return sum;
    }

    @Benchmark
    public int[] shuffle(IntData data, Source source) {
        int[] array = data.getData();
        RngNextIntInRangeBenchmark.shuffle(array, source.getRng());
        return array;
    }

    private static void shuffle(int[] array, UniformRandomProvider rng) {
        for (int i = array.length - 1; i > 0; --i) {
            int j = rng.nextInt(i);
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    @Benchmark
    public int pseudoShuffle(IntData data, Source source) {
        int sum = 0;
        for (int i = data.getData().length - 1; i > 0; --i) {
            sum += source.getRng().nextInt(i);
        }
        return sum;
    }

    static class Lemire31Pow2
    extends SplitMix32 {
        static final long POW_32 = 0x100000000L;

        Lemire31Pow2(long seed) {
            super(seed);
        }

        public int nextInt(int n) {
            this.checkStrictlyPositive(n);
            int nm1 = n - 1;
            if ((n & nm1) == 0) {
                return this.next() & nm1;
            }
            long m = ((long)this.nextInt() & Integer.MAX_VALUE) * (long)n;
            long l = m & Integer.MAX_VALUE;
            if (l < (long)n) {
                long t = (Integer.MIN_VALUE - n) % n;
                while (l < t) {
                    m = ((long)this.nextInt() & Integer.MAX_VALUE) * (long)n;
                    l = m & Integer.MAX_VALUE;
                }
            }
            return (int)(m >>> 31);
        }
    }

    static class Lemire31
    extends SplitMix32 {
        static final long POW_32 = 0x100000000L;

        Lemire31(long seed) {
            super(seed);
        }

        public int nextInt(int n) {
            this.checkStrictlyPositive(n);
            long m = ((long)this.nextInt() & Integer.MAX_VALUE) * (long)n;
            long l = m & Integer.MAX_VALUE;
            if (l < (long)n) {
                long t = (Integer.MIN_VALUE - n) % n;
                while (l < t) {
                    m = ((long)this.nextInt() & Integer.MAX_VALUE) * (long)n;
                    l = m & Integer.MAX_VALUE;
                }
            }
            return (int)(m >>> 31);
        }
    }

    static class LemirePow2
    extends SplitMix32 {
        static final long POW_32 = 0x100000000L;

        LemirePow2(long seed) {
            super(seed);
        }

        public int nextInt(int n) {
            this.checkStrictlyPositive(n);
            int nm1 = n - 1;
            if ((n & nm1) == 0) {
                return this.next() & nm1;
            }
            long m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
            long l = m & 0xFFFFFFFFL;
            if (l < (long)n) {
                long t = 0x100000000L % (long)n;
                while (l < t) {
                    m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
                    l = m & 0xFFFFFFFFL;
                }
            }
            return (int)(m >>> 32);
        }
    }

    static class Lemire
    extends SplitMix32 {
        static final long POW_32 = 0x100000000L;

        Lemire(long seed) {
            super(seed);
        }

        public int nextInt(int n) {
            this.checkStrictlyPositive(n);
            long m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
            long l = m & 0xFFFFFFFFL;
            if (l < (long)n) {
                long t = 0x100000000L % (long)n;
                while (l < t) {
                    m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
                    l = m & 0xFFFFFFFFL;
                }
            }
            return (int)(m >>> 32);
        }
    }

    static class JDKPow2
    extends SplitMix32 {
        JDKPow2(long seed) {
            super(seed);
        }

        public int nextInt(int n) {
            int val;
            int bits;
            this.checkStrictlyPositive(n);
            int nm1 = n - 1;
            if ((n & nm1) == 0) {
                return this.next() & nm1;
            }
            while ((bits = this.next() >>> 1) - (val = bits % n) + nm1 < 0) {
            }
            return val;
        }
    }

    static class JDK
    extends SplitMix32 {
        JDK(long seed) {
            super(seed);
        }

        public int nextInt(int n) {
            int val;
            int bits;
            this.checkStrictlyPositive(n);
            while ((bits = this.next() >>> 1) - (val = bits % n) + n - 1 < 0) {
            }
            return val;
        }
    }

    static abstract class SplitMix32
    extends IntProvider {
        private static final long GOLDEN_RATIO = -7046029254386353131L;
        protected long state;

        SplitMix32(long seed) {
            this.state = seed;
        }

        public int next() {
            long key = this.state += -7046029254386353131L;
            key = (key ^ key >>> 33) * 7109453100751455733L;
            return (int)((key ^ key >>> 28) * -3808689974395783757L >>> 32);
        }

        void checkStrictlyPositive(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("not strictly positive: " + n);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class Source {
        @Param(value={"jdk", "jdkPow2", "lemire", "lemirePow2", "lemire31", "lemire31Pow2"})
        private String name;
        private UniformRandomProvider rng;

        public UniformRandomProvider getRng() {
            return this.rng;
        }

        @Setup
        public void setup() {
            long seed = ThreadLocalRandom.current().nextLong();
            if ("jdk".equals(this.name)) {
                this.rng = new JDK(seed);
            } else if ("jdkPow2".equals(this.name)) {
                this.rng = new JDKPow2(seed);
            } else if ("lemire".equals(this.name)) {
                this.rng = new Lemire(seed);
            } else if ("lemirePow2".equals(this.name)) {
                this.rng = new LemirePow2(seed);
            } else if ("lemire31".equals(this.name)) {
                this.rng = new Lemire31(seed);
            } else if ("lemire31Pow2".equals(this.name)) {
                this.rng = new Lemire31Pow2(seed);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class IntData {
        @Param(value={"4", "16", "256", "4096", "16384"})
        private int size;
        private int[] data;

        public int[] getData() {
            return this.data;
        }

        @Setup
        public void setup() {
            this.data = PermutationSampler.natural((int)this.size);
        }
    }

    @State(value=Scope.Benchmark)
    public static class IntRange {
        @Param(value={"16", "17", "256", "257", "4096", "4097", "1073741824", "1073741825"})
        private int n;

        public int getN() {
            return this.n;
        }
    }
}

