/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.core;

import org.apache.commons.rng.UniformRandomProvider;

public final class BaselineUtils {
    private BaselineUtils() {
    }

    public static UniformRandomProvider getNextBytes() {
        return new BaselineNextBytes();
    }

    public static UniformRandomProvider getNextInt() {
        return new BaselineNextInt();
    }

    public static UniformRandomProvider getNextLong() {
        return new BaselineNextLong();
    }

    public static UniformRandomProvider getNextBoolean() {
        return new BaselineNextBoolean();
    }

    public static UniformRandomProvider getNextFloat() {
        return new BaselineNextFloat();
    }

    public static UniformRandomProvider getNextDouble() {
        return new BaselineNextDouble();
    }

    private static final class BaselineNextDouble
    extends DefaultProvider {
        private double value;

        private BaselineNextDouble() {
        }

        @Override
        public double nextDouble() {
            return this.value;
        }
    }

    private static final class BaselineNextFloat
    extends DefaultProvider {
        private float value;

        private BaselineNextFloat() {
        }

        @Override
        public float nextFloat() {
            return this.value;
        }
    }

    private static final class BaselineNextBoolean
    extends DefaultProvider {
        private boolean value;

        private BaselineNextBoolean() {
        }

        @Override
        public boolean nextBoolean() {
            return this.value;
        }
    }

    private static final class BaselineNextLong
    extends DefaultProvider {
        private long value;

        private BaselineNextLong() {
        }

        @Override
        public long nextLong() {
            return this.value;
        }

        @Override
        public long nextLong(long n) {
            return this.value;
        }
    }

    private static final class BaselineNextInt
    extends DefaultProvider {
        private int value;

        private BaselineNextInt() {
        }

        @Override
        public int nextInt() {
            return this.value;
        }

        @Override
        public int nextInt(int n) {
            return this.value;
        }
    }

    private static final class BaselineNextBytes
    extends DefaultProvider {
        private byte value;

        private BaselineNextBytes() {
        }

        @Override
        public void nextBytes(byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = this.value;
            }
        }

        @Override
        public void nextBytes(byte[] bytes, int start, int len) {
            for (int i = start; i < len; ++i) {
                bytes[i] = this.value;
            }
        }
    }

    private static abstract class DefaultProvider
    implements UniformRandomProvider {
        private DefaultProvider() {
        }

        public void nextBytes(byte[] bytes) {
        }

        public void nextBytes(byte[] bytes, int start, int len) {
        }

        public int nextInt() {
            return 0;
        }

        public int nextInt(int n) {
            return 0;
        }

        public long nextLong() {
            return 0L;
        }

        public long nextLong(long n) {
            return 0L;
        }

        public boolean nextBoolean() {
            return false;
        }

        public float nextFloat() {
            return 0.0f;
        }

        public double nextDouble() {
            return 0.0;
        }
    }
}

